/*
 *
 *
 *
 */
package cn.gongler.util;

/**
 * 支持抛出Exception的Runnable
 *
 * @author gongler
 * @since 2016.08.01
 */
@FunctionalInterface
public interface ITask {

    void run() throws Exception;

    //    default void execute() throws Exception {
//        run();
//    }
    default void executeWithCatchAny() {
        GonglerUtil.ExecuteWithCatchAny(this::run);
    }

    default void executeWithThrowAny() {
        GonglerUtil.ExecuteWithThrowAny(this::run);
    }

    default Runnable toRunnable() {
        return this::executeWithThrowAny;
    }

}
