/*
 *
 *
 *
 */
package cn.gongler.util;

import cn.gongler.util.function.ExceptionIntConsumer;
import cn.gongler.util.function.ExceptionIntFunction;
import cn.gongler.util.function.ExceptionSupplier;
import cn.gongler.util.text.StringLinker;

import java.io.*;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 主工具类
 * @author gongler
 */
public class GonglerUtil {

    private static final long serialVersionUID = 11369096262707202L;//Util

    protected GonglerUtil() {
    }

    public static Charset GBK;
    public static Charset GB18030;//2022年10月29日
    static {
        try {
            GBK = GBK();
        }catch(Exception e){}
        try {
            GB18030 = GB18030();
        }catch(Exception e){}
    }
    ////////////////////////////////////////////////////////////////////////////
    //常量区

    public static  final Integer INTEGER_0 = Integer.valueOf(0);
    public static final Long LONG_0 = Long.valueOf(0L);
    public static final Double DOUBLE_0 = Double.valueOf(0D);

    public static final BigInteger BIG_INT_0 = BigInteger.valueOf(0);//new BigInteger("0");
    public static final BigInteger BIG_INT_10 = BigInteger.valueOf(10);//new BigInteger("10");
    public static final BigInteger BIG_INT_100 = BigInteger.valueOf(100);//new BigInteger("100");
    public static final BigInteger BIG_INT_FF = BigInteger.valueOf(0xFF);//new BigInteger("255");


    ////////////////////////////////////////////////////////////////////////////
    //数字类型便捷转换

    /**
     * 避免写2层括号 int a; byte b = toByte(b)+3;//byte b = ((byte)b)+3;
     *
     * @param val value
     * @return byte
     */
    public static byte Byte(long val) {//20160824
        return (byte) val;
    }

    /**
     * 避免写2层括号 int a; byte b = toByte(b)+3;//byte b = ((byte)b)+3;
     *
     * @param val long value
     * @return int
     */
    public static int Int(long val) {//20160824
        return (int) val;
    }

    public static int Int(short val) {//20160824
        return (int) val & 0xFFFF;
    }

    public static int Int(byte val) {//2022年10月4日
        return ((int) val) & 0xFF;
    }

    public static int Int(double val) {//20171024
        return (int) val;
    }

    public static double Round(double val, int digits) {//20160824四舍五入
        double tmp = Math.pow(10, digits);
        return Math.round(val * tmp) / tmp;
    }
    ////////////////////////////////////////////////////////////////////////////
    //常用数学函数

    public static int min(int... vals) {//gongler20180306add
        int min = Integer.MAX_VALUE;
        for (int val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static int max(int... vals) {//gongler20180306add
        int max = Integer.MIN_VALUE;
        for (int val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static long min(long... vals) {//gongler20180306add
        long min = Long.MAX_VALUE;
        for (long val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static long max(long... vals) {//gongler20180306add
        long max = Long.MIN_VALUE;
        for (long val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static double min(double... vals) {//gongler20180306add
        double min = Double.MAX_VALUE;
        for (double val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static double max(double... vals) {//gongler20180306add
        double max = Long.MIN_VALUE;
        for (double val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static double Avg(double... vals) {//gongler20180306add
        double sum = 0;
        int count = 0;
        for (double val : vals) {
            sum += val;
            count++;
        }
        return sum / count;
    }

//    public static <T extends Comparable> T MiddleValue(T... vals) {//gongler20190410add
//        return MiddleValue(Comparator.naturalOrder(), vals);
//    }

    public static <T> T MiddleValue(Collection<T> vals, Comparator<T> c) {//public static <T> T MiddleValue(Collection<T> vals, Comparator<T> c) {//gongler20190410add
        TreeSet<T> set = new TreeSet<>(c);
        set.addAll(vals);
        int i = 0, middleIndex = set.size() / 2;
        for (T o : set) {
            if (i == middleIndex) {
                return o;
            }
            i++;
        }
        return null;
    }

    public static long MiddleValue(long... vals) {//gongler20190410add
        Arrays.sort(vals);
        return vals[vals.length / 2];
    }

    public static int MiddleValue(int... vals) {//gongler20190410add
        Arrays.sort(vals);
        return vals[vals.length / 2];
    }

    ////////////////////////////////////////////////////////////////////////////
    //WithDefault

    public static <T> T WithDefault(T val, T defaultVal) {//20160419
        return val == null ? defaultVal : val;
    }

    public static <T> T WithDefault(T val, Supplier<T> defaultVal) {//20160430
        return val == null ? defaultVal.get() : val;
    }

    public static <T, R> R WithDefault(T val, R defaultVal, Function<T, R> mapper) {//20180327
        return val == null ? defaultVal : mapper.apply(val);
    }

    //gongler20180327 eclipse:会引起参数歧义
//    public static <T, R> R WithDefault(T val, Function<T, R> mapper, R defaultVal) {//20180327 仅用于其他基本类型，请优先使用其他方法。
//        return val == null ? defaultVal:mapper.apply(val);
//    }
//
//    public static <T> int WithDefault(T val, int defaultVal, ToIntFunction<T> mapper) {//20180327
//        return val == null ? defaultVal:mapper.applyAsInt(val);
//    }
//
//    public static <T> long WithDefault(T val, long defaultVal, ToLongFunction<T> mapper) {//20180327
//        return val == null ? defaultVal:mapper.applyAsLong(val);
//    }
//
//    public static <T> boolean WithDefault(T val, boolean defaultVal, Function<T, Boolean> mapper) {//20180327
//        return val == null ? defaultVal:mapper.apply(val);
//    }
    public static <T> String WithDefault(T val, String defaultVal) {//20180327
        return WithDefault(val, defaultVal, String::valueOf);
    }

    public static Integer WithDefault(Integer val) {//20171228
        return WithDefault(val, 0);
    }

    public static Long WithDefault(Long val) {//20171228
        return WithDefault(val, 0L);
    }

    public static Short WithDefault(Short val) {//20171228
        return WithDefault(val, (short) 0);
    }

    public static Byte WithDefault(Byte val) {//20171228
        return WithDefault(val, (byte) 0);
    }

    public static Double WithDefault(Double val) {//20171228
        return WithDefault(val, 0D);
    }

    public static Float WithDefault(Float val) {//20171228
        return WithDefault(val, 0f);
    }

    public static Boolean WithDefault(Boolean val) {//20171228
        return WithDefault(val, Boolean.FALSE);
    }

    public static String WithDefault(String val) {//20171228
        return WithDefault(val, "");
    }

    public static <T> List<T> WithDefault(List<T> val) {//2022年10月18日
        return val != null ? val : Collections.emptyList();
    }

    public static <T> Set<T> WithDefault(Set<T> val) {//2022年10月18日
        return val != null ? val : Collections.emptySet();
    }

    public static <T> SortedSet<T> WithDefault(SortedSet<T> val) {//2022年10月18日
        return val != null ? val : Collections.emptySortedSet();
    }

    public static <T> NavigableSet<T> WithDefault(NavigableSet<T> val) {//2022年10月18日
        return val != null ? val : Collections.emptyNavigableSet();
    }

    public static <K, V> Map<K, V> WithDefault(Map<K, V> val) {//2022年10月18日
        return val != null ? val : Collections.emptyMap();
    }

    public static <K, V> SortedMap<K, V> WithDefault(SortedMap<K, V> val) {//2022年10月18日
        return val != null ? val : Collections.emptySortedMap();
    }

    public static <K, V> NavigableMap<K, V> WithDefault(NavigableMap<K, V> val) {//2022年10月18日
        return val != null ? val : Collections.emptyNavigableMap();
    }

    public static <T> T WithConsumer(T val, Consumer<T> op) {//20160913
        op.accept(val);
        return val;
    }

    public static <T> T WithNotNullConsumer(T val, Consumer<T> op) {//2022年10月17日
        if (val != null) op.accept(val);
        return val;
    }

    public static <T> void ifPresent(T param, Consumer<T> consumer) {//2022年10月17日
        if (param != null) consumer.accept(param);
    }

    ////////////////////////////////////////////////////////////////////////////
    //线程相关

    public static Thread StartDaemonThread(String threadName, ITask task) {//20160413 重构代码是把Thread创建和执行移到这里。
        Thread thread = new Thread(RunnableWithCatchAny(task), threadName);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static void ExecuteWithCatchAny(final ITask task) {//20160425add
        try {
            task.run();
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void ExecuteWithThrowAny(final ITask task) {//20160425add
        try {
            task.run();
        } catch (Exception e) {//只对检查异常进行重新封装，以便能继续上抛
            throw toRuntimeException(e);
        }
    }

    public static Runnable RunnableWithCatchAny(final ITask task) {
        return () -> ExecuteWithCatchAny(task);
    }

    public static Runnable RunnableWithThrowAny(final ITask task) {
        return () -> ExecuteWithThrowAny(task);
    }

    public static <T> T CallWithThrowAny(final Callable<T> task) {//20160816add
        try {
            return task.call();
        } catch (Exception e) {//只对检查异常进行重新封装，以便能继续上抛
            throw toRuntimeException(e);
        }
    }

    public static <T> T CallWithCatchAny(final Callable<T> task, T defaultVal) {//20160816add
        try {
            return task.call();
        } catch (Throwable e) {//只对检查异常进行重新封装，以便能继续上抛
            e.printStackTrace();
            return defaultVal;
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    //线程：超时处理
    public static void WithTimeout(Runnable task, Duration timeout) {//gongleradd20171223重量级操作，每次执行都需要新建临时线程。可用于重要但不是频繁的数据库操作。
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(timeout.toMillis());
            thread.interrupt();
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private static final ExecutorService timeoutThreadPool = Executors.newCachedThreadPool();  //gongleradd20190709减少第一个版本的线程创建频率，待验证

    /**
     * 添加超时终止的功能
     *
     * @param task    任务
     * @param timeout 超时用时
     */
    public static void WithTimeout2Beta(ITask task, Duration timeout) {//gongleradd20190709
        try {
            timeoutThreadPool.invokeAny(Collections.singleton((() -> {
                task.run();
                return task;
            })), timeout.toMillis(), TimeUnit.MILLISECONDS);
        } catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new CompletionException("TimeoutException of " + timeout + " when execute task:" + task, ex);
        }
    }

    /**
     * 增加重试次数
     *
     * @param task        任务
     * @param timeout     超时用时
     * @param expiredTime 过期
     */
    public static void WithTimeout2Beta(ITask task, Duration timeout, Duration expiredTime) {//gongleradd20191210
        LocalDateTime to = LocalDateTime.now().plus(expiredTime);
        while (LocalDateTime.now().isBefore(to)) {
            try {
                timeoutThreadPool.invokeAny(Collections.singleton((() -> {
                    task.run();
                    return null;
                })), timeout.toMillis(), TimeUnit.MILLISECONDS);
                //20221016 return;
            } catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new CompletionException("TimeoutException of " + timeout + " when execute task:" + task, ex);
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    //异常

    public static RuntimeException toRuntimeException(Exception e) {
        return RuntimeExceptionFromException.of(e);
    }

    public static Exception toOriginalException(RuntimeException e) {
        return RuntimeExceptionFromException.toOriginal(e);
    }

    ////////////////////////////////////////////////////////////////////////////
    //重复与重试

    public static void Repeat(int times, ITask task) {//20160425add
        for (int i = 1; i <= times; i++) {
            task.executeWithThrowAny();//ExecuteWithThrowAny(task::run);//task.run();
        }
    }

    public static void Repeat(int times, ExceptionIntConsumer task) {//20160425add
        for (int i = 1; i <= times; i++) {
            try {
                task.accept(i);
            } catch (Exception e) {
                throw toRuntimeException(e);
            }
        }
    }

    public static String Repeat(int times, CharSequence msg) {//2022年10月7日
        return StringLinker.of().addRepeat(msg, times).toString();
    }

    /**
     * 如果遇到异常，则重新尝试不超过限定的次数。
     *
     * @param times 次数
     * @param task  任务
     * @param <R>   返回类型
     * @return result
     */
    public static <R> R RetryTimes(int times, ExceptionIntFunction<R> task) {//20160909add
        for (int i = 1; i <= times; i++) {
            try {
                return task.apply(i);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
    ////////////////////////////////////////////////////////////////////////////
    //数组：newArray

    public static <T> T[] newArray(Class<T> aClass, int size, ExceptionIntFunction<T> func) {//20160826add
        T[] array = (T[]) Array.newInstance(aClass, size);
        Repeat(size, i -> array[i] = func.apply(i));
        return array;
    }

    public static byte[] newByteArray(int size, IntUnaryOperator func) {//20160826add
        byte[] array = new byte[size];
        Repeat(size, i -> array[i] = (byte)func.applyAsInt(i));
        return array;
    }

    public static int[] newIntArray(int size, IntUnaryOperator func) {//20160826add
        int[] array = new int[size];
        Repeat(size, i -> array[i] = func.applyAsInt(i));
        return array;
    }

    public static long[] newLongArray(int size, LongUnaryOperator func) {//20160826add
        long[] array = new long[size];
        Repeat(size, i -> array[(int) i] = func.applyAsLong(i));
        return array;
    }

    ////////////////////////////////////////////////////////////////////////////
    //空数组

    private static final Object[] EMPTY_ARRAY = {};
    private static final int[] EMPTY_INT_ARRAY = {};
    private static final long[] EMPTY_LONG_ARRAY = {};
    private static final byte[] EMPTY_BYTE_ARRAY = {};

    @SuppressWarnings("unchecked")
    public static <T> T[] emptyArray() {
        return (T[]) EMPTY_ARRAY;
    }

    public static int[] emptyIntArray() {
        return EMPTY_INT_ARRAY;
    }

    public static long[] emptyLongArray() {
        return EMPTY_LONG_ARRAY;
    }

    public static byte[] emptyByteArray() {
        return EMPTY_BYTE_ARRAY;
    }

    ////////////////////////////////////////////////////////////////////////////
    //枚举

    /**
     * 枚举适配器，用返回null作为结束标记。
     *
     * @param <T> Type
     * @param sup supplier
     * @return iterable
     */
    public static <T> Iterable<T> IterableAdapter(ExceptionSupplier<T> sup) {//20190416 to private //20180818add
        return () -> new Iterator<T>() {
            T cur;

            @Override
            public boolean hasNext() {
                cur = CallWithThrowAny(sup::get);
                return cur != null;
            }

            @Override
            public T next() {
                return cur;
            }
        };
    }

    public static <T> Iterator<T> IteratorAdapter(ExceptionSupplier<T> sup) {//20190416 to private //20180818add
        return new Iterator<T>() {
            T cur;

            @Override
            public boolean hasNext() {
                cur = CallWithThrowAny(sup::get);
                return cur != null;
            }

            @Override
            public T next() {
                return cur;
            }
        };
    }

    ////////////////////////////////////////////////////////////////////////////
    public static <T> Iterable<T> IterableAdapter(T[] sup) {//20180824add
        return () -> new Iterator<T>() {
            int i = 0;

            @Override
            public boolean hasNext() {
                return i < sup.length;
            }

            @Override
            public T next() {
                return sup[i++];
            }
        };
    }

    public static <T> Iterator<T> IteratorAdapter(T[] sup) {//20180824add forEach
        return new Iterator<T>() {
            int i = 0;

            @Override
            public boolean hasNext() {
                return i < sup.length;
            }

            @Override
            public T next() {
                return sup[i++];
            }
        };
    }

    ////////////////////////////////////////////////////////////////////////////
    public static <E> Iterable<E> IterableAdapter(Enumeration<E> source) {//20190416rename//20150915gongleradd
        return () -> new Iterator<E>() {

            @Override
            public boolean hasNext() {
                return source.hasMoreElements();
            }

            @Override
            public E next() {
                return source.nextElement();
            }
        };
    }

    public static <E> Iterator<E> IteratorAdapter(Enumeration<E> source) {//20150915gongleradd forEach
        return new Iterator<E>() {

            @Override
            public boolean hasNext() {
                return source.hasMoreElements();
            }

            @Override
            public E next() {
                return source.nextElement();
            }
        };
    }

    ////////////////////////////////////////////////////////////////////////////
    public static Iterable<ResultSet> IterableAdapter(ResultSet rs) {//20190416add
        return () -> new Iterator<ResultSet>() {

            @Override
            public boolean hasNext() {
                return CallWithThrowAny(rs::next);
            }

            @Override
            public ResultSet next() {
                return rs;
            }
        };
    }

    public static Iterator<ResultSet> IteratorAdapter(ResultSet rs) {//20190416add forEach
        return new Iterator<ResultSet>() {

            @Override
            public boolean hasNext() {
                return CallWithThrowAny(rs::next);
            }

            @Override
            public ResultSet next() {
                return rs;
            }
        };
    }

    ////////////////////////////////////////////////////////////////////////////
    public static <T, R> Iterable<R> IterableFilter(Iterable<T> list, Class<R> aClass) {//20180824add
        List<R> ret = new ArrayList<>();
        for (T e : list) {
            if (aClass.isInstance(e)) {
                ret.add((R) e);
            }
        }
        return ret;
    }

    public static <E> Iterator<E> LimitIterator(long limit, Iterator<E> original) {//20180818add
        return new Iterator<E>() {
            long i = 0;

            @Override
            public boolean hasNext() {
                return original.hasNext() && i < limit;
            }

            @Override
            public E next() {
                i++;
                return original.next();
            }
        };
    }

    public static <E> Collection<E> LimitIterator(Collection<E> original, long limit) {//20180818add
        return new ArrayList<>();
    }

    @Deprecated //20190416 to deprecated
    public static <E> Iterable<E> LimitIterable(long limit, Iterable<E> original) {//20180818add
        return () -> LimitIterator(limit, original.iterator());
    }

    public static <E> Collection<E> Limit(Iterable<E> original, long limit) {//20190416add
        Collection<E> ret = new ArrayList<>();
        int i = 0;
        for (E e : original) {
            ret.add(e);
            if (++i >= limit) {
                break;
            }
        }
        return ret;
    }

    public static <K, V> Map<K, V> LimitMap(Map<K, V> original, long limit) {//20190416add
        return new AbstractMap<K, V>() {
            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new HashSet<>(Limit(original.entrySet(), limit));
            }
        };
    }

    /**
     * 仅用于for循环
     *
     * @param <E> E
     * @param sup supplier
     * @return 返回值
     */
    public static <E> Iterable<E> ForEachFrom(ExceptionSupplier<E> sup) {//20180818add
        return IterableAdapter(sup);
    }

    ////////////////////////////////////////////////////////////////////////////
    // decode num from string

    /**
     * 与Integer.decode()区别：1. 前导0不再解析成8进制（BUG根源）；增加0o八进制前导符；增加0b二进制前导符号 2.
     * 支持后缀单位K、M、G
     *
     * @param nm number string
     * @return int
     * @throws NumberFormatException 格式异常
     */
    public static int DecodeInt(String nm) throws NumberFormatException {//20160823
        return (int) DecodeLong(nm);
    }

    /**
     * 与Long.decode()区别：前导0不再解析成8进制（BUG根源）；增加0o八进制前导符；增加0b二进制前导符号。 支持后缀单位K、M、G
     *
     * @param nm number string
     * @return number
     * @throws NumberFormatException 格式异常
     */
    public static long DecodeLong(String nm) throws NumberFormatException {//20160823
        String danweiStr = SuffixOf(nm, 1);
        long danwei = 1;
        switch (danweiStr) {
            case "k":
            case "K":
                danwei = KILO;
                break;
            case "m":
            case "M":
                danwei = MEGA;
                break;
            case "g":
            case "G":
                danwei = GIGA;
                break;
        }
        if (danwei > 1) {
            return _decodeLong(ExcludeEndOf(nm, 1)) * danwei;
        } else {
            return _decodeLong(nm);
        }
    }

    /**
     * 与Long.decode()区别: 前导0不再解析成8进制（BUG根源）；增加0o八进制前导符；增加0b二进制前导符号
     *
     * @param nm
     * @return
     * @throws NumberFormatException
     */
    private static long _decodeLong(String nm) throws NumberFormatException {//20160823
        int radix = 10;
        int index = 0;
        boolean negative = false;
        long result;

        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        // Handle sign, if present
        if (firstChar == '-') {
            negative = true;
            index++;
        } else if (firstChar == '+') {
            index++;
        }

        // Handle radix specifier, if present
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            index++;
            radix = 16;
        } else if (nm.startsWith("0o", index) || nm.startsWith("0O", index)) {
            index += 2;
            radix = 8;
        } else if (nm.startsWith("0b", index) || nm.startsWith("0B", index)) {
            index += 2;
            radix = 2;
//        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
//            index++;
//            radix = 8;
        }

        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }

        try {
            result = Long.valueOf(nm.substring(index), radix);
            result = negative ? -result : result;//result = negative ? -result.longValue()) : result;
        } catch (NumberFormatException e) {
            // If number is Long.MIN_VALUE, we'll end up here. The next line
            // handles this case, and causes any genuine format error to be
            // rethrown.
            String constant = negative ? ("-" + nm.substring(index))
                    : nm.substring(index);
            result = Long.valueOf(constant, radix);
        }
        return result;
    }

    /**
     * @param str '123,456,...'
     * @return 返回值
     */
    public static List<Integer> DecodeIntegers(String str) {//20160823
        return IsEmptyString(str) ? Collections.emptyList() : Arrays.stream(str.split(",")).map(GonglerUtil::DecodeInt).collect(Collectors.toList());
    }

    /**
     * @param str '123,456,...'
     * @return 返回值
     */
    public static List<Long> DecodeLongs(String str) {//20160823
        return IsEmptyString(str) ? Collections.emptyList() : Arrays.stream(str.split(",")).map(GonglerUtil::DecodeLong).collect(Collectors.toList());
    }

    //    private static String DecodeStr(String str) {//2022年10月16日补注：可以直接用URLDecoder
//        StringBuilder buf = new StringBuilder();
//        for (int i = 0; i < str.length(); i++) {
//            char ch = str.charAt(i);
//            if (ch == '%') {
//                int v = Integer.parseInt(str.substring(i + 1, i + 3), 16);
//                buf.append((char) v);
//                i += 2;
//            } else {
//                buf.append(ch);
//            }
//        }
//        return buf.toString();
//    }
//
    public static Boolean parseBoolean(String boolStr, Boolean defaultBool) {//gongler20190114 Util增加容错强的parseBoolean。
        if (boolStr == null) {
            return defaultBool;
        }
        Boolean ret;
        switch (boolStr.toUpperCase()) {
            case "YES":
            case "Y":
            case "TRUE":
            case "T":
            case "ON":
                ret = true;
                break;
            case "NO":
            case "N":
            case "FALSE":
            case "F":
            case "OFF":
                ret = false;
                break;
            default:
                ret = defaultBool;
        }
        return ret;
    }


    public static long parseUnsignedLong(String s) throws NumberFormatException {//gongler20180426add
        return Long.parseUnsignedLong(s);
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {//gongler20180426add
        return Long.parseUnsignedLong(s, radix);
    }

    public static int parseUnsignedInt(String s) throws NumberFormatException {//gongler20180426add
        return Integer.parseUnsignedInt(s);
    }

    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {//gongler20180426add
        return Integer.parseUnsignedInt(s, radix);
    }

    public static short parseUnsignedShort(String s) throws NumberFormatException {//gongler20180426add
        return parseUnsignedShort(s, 10);
    }

    public static short parseUnsignedShort(String s, int radix) throws NumberFormatException {//gongler20180426add
        int val = Integer.parseUnsignedInt(s, radix);
        if (val < 0 || val > 0xFFFF) {
            throw new NumberFormatException();
        }
        return (short) val;
    }

    public static short parseUnsignedByte(String s) throws NumberFormatException {//gongler20180426add
        return parseUnsignedByte(s, 10);
    }

    public static short parseUnsignedByte(String s, int radix) throws NumberFormatException {//gongler20180426add
        int val = Integer.parseUnsignedInt(s, radix);
        if (val < 0 || val > 0xFF) {
            throw new NumberFormatException();
        }
        return (byte) val;
    }

    ////////////////////////////////////////////////////////////////////////////
    //String 处理

    public static boolean IsEmptyString(String str) {//20160823
        return !IsNotEmptyString(str);
    }

    public static boolean IsNotEmptyString(String str) {//20160823
        return str != null && str.length() > 0;
    }

    public static String SuffixOf(String str, int charCount) {
        return str.substring(str.length() - charCount);
    }

    public static String PrefixOf(String str, int charCount) {
        return str.substring(0, charCount);
    }

    public static String ExcludeEndOf(String str, int charCount) {
        return str.substring(0, str.length() - charCount);
    }

    ////////////////////////////////////////////////////////////////////////////
    //字符串： toString
    public static String ToString(Object... items) {//gongler20160414add
        StringBuilder buf = new StringBuilder();
        for (Object item : items) {
            buf.append(item);
        }
        return buf.toString();
    }

    public static String PrintStackTraceToString(Throwable e) {//20160801gongleradd
        CharArrayWriter bout = new CharArrayWriter(512);
        try (PrintWriter print = new PrintWriter(bout, true)) {
            e.printStackTrace(print);
        }
        return bout.toString();
    }


    public static String GpsDoubleToString(double gps) {//20160825add 截断过长数据
        return String.format("%.6f", gps);
    }

    ////////////////////////////////////////////////////////////////////////////
    //字符串： 字符串处理

    /**
     * 返回字符串prefix后面的字符串。例如: SubString("abcdefgh", "def")=="gh"
     *
     * @param msg       msg
     * @param delimiter 分隔符
     * @return 后部字符串
     */
    public static String SubstringAfter(String msg, String delimiter) {//2021年12月13日,2022年10月5日09:34:29
        if (msg == null) return null;
        int index = msg.indexOf(delimiter);
        if (index >= 0) {
            return msg.substring(index + delimiter.length());
        } else return null;
    }

    public static String SubstringBefore(String msg, String delimiter) {//2021年12月13日，2022年10月5日
        if (msg == null) return null;
        int index = msg.indexOf(delimiter);
        if (index >= 0) {
            return msg.substring(0, index);
        } else return null;
    }

    public static String lastSubstring(String msg, int charCntMax) {//2022年10月5日
        if (msg == null) return null;
        int from = Math.max(msg.length() - charCntMax, 0);
        return msg.substring(from, msg.length());
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    //K, M等单位换算
    private static final long KILO = 1024;//KILO
    private static final long MEGA = 1024 * KILO;//MEGA
    private static final long GIGA = 1024 * MEGA;//GIGA
    private static final long TERA = 1024 * GIGA;//TERA
//    public static final long PETA = 1024 * TERA;//PETA
//    public static final long EXA = 1024 * PETA;//EXA
//    public static final long ZETTA = 1024 * EXA;//ZETTA
//    public static final long YOTTA = 1024 * ZETTA;//YOTTA

    public static long Kilo(long val) {
        return KILO * val;
    }

    public static long Mega(long val) {
        return MEGA * val;
    }

    public static long Giga(long val) {
        return GIGA * val;
    }

    public static long Tera(long val) {
        return TERA * val;
    }

    ////////////////////////////////////////////////////////////////////////////
    // datetime变换

    //    public static LocalDateTime LocalDateTimeOf(long millns) {
//        
//        return LocalDateTime.ofInstant(Instant.MIN, zone);
//    }
    public static LocalDateTime LocalDateTime2000_01_01 = LocalDateTime.of(2000, 1, 1, 0, 0);//20160919 鉴于LocalDateTime.MIN 有时好像由问题，暂时定义该项。2000-01-01 00:00

    public static long toEpochMilli(LocalDateTime ldt) {//gongler20181030
        return ldt.toInstant(ZoneOffset.ofTotalSeconds(TimeZone.getDefault().getRawOffset() / 1000)).toEpochMilli();
    }

    public static long toEpochMilli(OffsetDateTime odt) {//gongler20181030
        return odt.toInstant().toEpochMilli();
    }

    public static OffsetDateTime toOffsetDateTime(long millis) {//gongler20181030
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }

//    public static LocalDateTime toLocalDateTime(long millis){//gongler20181030
//        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
//    }

    public static LocalDateTime toLocalDateTime(long millis) {//gongler20181030 疑似20160919添加
        return new Timestamp(millis).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(java.util.Date oldTime) {
        return LocalDateTime.ofInstant(oldTime.toInstant(), ZoneId.systemDefault());
    }

    public static Timestamp toTimestamp(LocalDateTime ldt) {
        return new Timestamp(toEpochMilli(ldt));
    }

    public static java.util.Date toUtilDate(LocalDateTime ldt) {
        return java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }


    public static Timestamp TIMESTAMP_NULL = new Timestamp(0L);

    private final static DateTimeFormatter YYYYMMDD_HHMMSSXXX = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");//2019-04-16add
    private final static DateTimeFormatter YYYYMMDD_HHMMSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");//2019-04-16add
    private final static DateTimeFormatter YYYYMMDD_HHMM = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");//2019-04-16add
    private final static DateTimeFormatter YYYYMMDD = DateTimeFormatter.ofPattern("yyyy-MM-dd");//2019-04-16add
    private final static DateTimeFormatter HHMMSS = DateTimeFormatter.ofPattern("HH:mm:ss");//2019-04-16add
    private final static DateTimeFormatter HHMM = DateTimeFormatter.ofPattern("HH:mm");//2019-04-16add

    public static String HHMM(LocalDateTime time) {//20190417add
        if (time == null) return null;
        return HHMM.format(time);
    }

    public static String HHMM(long time) {//20190417add
        return new SimpleDateFormat("HH:mm").format(time);
    }

    public static String HHMMSS(LocalDateTime time) {//20190417add
        if (time == null) return null;
        return HHMMSS.format(time);
    }

    public static String HHMMSS(long time) {//20190417add
        return new SimpleDateFormat("HH:mm:ss").format(time);
    }

    public static String YYYYMMDD(LocalDateTime time) {//20190417add
        if (time == null) return null;
        return YYYYMMDD.format(time);
    }

    public static String YYYYMMDD(long time) {//20190417add
        return new SimpleDateFormat("yyyy-MM-dd").format(time);
    }

    public static String YYYYMMDD_HHMM(LocalDateTime time) {//20190417add
        if (time == null) return null;
        return YYYYMMDD_HHMM.format(time);//return String.format("%04d-%02d-%02d %02d:%02d", time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute());
    }

    public static String YYYYMMDD_HHMM(long time) {//20190417add
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(time);
    }

    public static String YYYYMMDD_HHMMSS(LocalDateTime time) {//20190417add
        if (time == null) return null;
        return YYYYMMDD_HHMMSS.format(time);//return String.format("%04d-%02d-%02d %02d:%02d:%02d", time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
    }

    public static String YYYYMMDD_HHMMSS(long time) {//20160927add
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time);
    }

    public static String YYYYMMDD_HHMMSSXXX(LocalDateTime time) {//20190417add
        if (time == null) return null;
        return YYYYMMDD_HHMMSSXXX.format(time);//return String.format("%04d-%02d-%02d %02d:%02d:%02d", time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
    }

    public static String YYYYMMDD_HHMMSSXXX(long time) {//20160927add
        return new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS").format(time);
    }
    ////////////////////////////////////////////////////////////////////////////
    //日期格式化

    public static Charset GBK() {//gongleradd20170313
        return Charset.forName("GBK");
    }

    public static Charset GB18030() {//gongleradd20170313
        return Charset.forName("GB18030");
    }

    public static int msgLedWidth(String msg) {//gongleradd20170313
        return msg.getBytes(GBK()).length;//GB18030\UTF-8变长，不适合。
    }

    /**
     * 利用线路名排序线路。需要提供从线路类获取线路名的函数。用例：
     * <pre>
     * List&lt;Line&gt; list = 。。。
     * System.out.println(""+list);
     * Collections.sort(list, Util.LineComparator(Line::lineName));//假定含有方法：String Line.lineName()
     * System.out.println(""+list);
     * </pre>
     *
     * @param <T>  Object Type
     * @param func function
     * @return ChineseLinenameComparator
     */
    public static <T> Comparator<T> BusLineNameComparator(Function<T, String> func) {//gongleradd20170401
        return ChineseLinenameComparator.of(func);//gongler20171027 PrefixLinenameComparator.of(func);
    }

    /**
     * 比较线路名，可用于排序。例子：
     * <pre>
     * List&lt;String&gt; list = Arrays.asList("11路", "9路", "快速1路", "123路环线");
     * System.out.println(""+list);
     * Collections.sort(list, Util.LineComparator());
     * System.out.println(""+list);
     * </pre>
     *
     * @return LineComparator
     */
    public static Comparator<String> BusLineNameComparator() {//gongleradd20170401
        return BusLineNameComparator(Function.identity());
    }

    public static <T> List<T> SortedListByBusLineName(Collection<T> original, Function<T, String> toBusLineName) {//2022年12月3日
        return original.stream().sorted(BusLineNameComparator(toBusLineName)).collect(Collectors.toList());
    }

    public static <T> Comparator<T> ChineseNameComparator(Function<T, String> func) {//2022年12月3日
        return ChineseLinenameComparator.of(func);//TODO 2022年12月3日，内部暂时借用LineComparator，未来必要时可以独立定义比较器
    }

    public static Comparator<String> ChineseNameComparator() {//2022年12月3日
        return ChineseNameComparator(Function.identity());
    }

    public static <T> List<T> SortedListByChineseName(Collection<T> original, Function<T, String> toChineseName) {//2022年12月3日
        return original.stream().sorted(ChineseNameComparator(toChineseName)).collect(Collectors.toList());
    }

    //    public static void IfPrefix(String msg, String prefix, Consumer<String> consumer) {
//        if (msg.startsWith(prefix)) {
//            String substr = msg.substring(prefix.length());
//            consumer.accept(substr);
//        }
//    }
//
//    public static void IfPrefix(String msg, String prefix, Consumer<String> consumer, Runnable elseConsumer) {
//        if (msg.startsWith(prefix)) {
//            String substr = msg.substring(prefix.length());
//            consumer.accept(substr);
//        } else {
//            elseConsumer.run();
//        }
//    }
    public static Duration Duration(Runnable task) {//gongler20180108add
        LocalDateTime from = LocalDateTime.now();
        task.run();
        LocalDateTime to = LocalDateTime.now();
        return Duration.between(from, to);
    }

    public static String toUnsignedString(long val) {//gongler20180426add
        return Long.toUnsignedString(val);
    }

    public static String toUnsignedString(long val, int radix) {//gongler20180426add
        return Long.toUnsignedString(val, radix);
    }

    //    public static int UnsignedByte(byte val){//gongler20180426add
//        return val&0xFF;
//    }
//
//    public static int UnsignedShort(short val){//gongler20180426add
//        return val&0xFFFF;
//    }
//
//    public static long UnsignedInt(int val){//gongler20180426add
//        return val&0xFFFFFFFFL;
//    }
    public static <A> int CompareAny(A a1, A a2) {
        if (Objects.equals(a1, a2)) {//a1==a2, null==null
            return 0;
        } else if (a1 instanceof Number && a2 instanceof Number && a1.getClass() != a2.getClass()) {//都是数值类型，但具体类型不同时，同意按Double比较
            return Double.compare(((Number) a1).doubleValue(), ((Number) a2).doubleValue());
        } else if (a1 instanceof Comparable && a2 instanceof Comparable && a1.getClass() == a2.getClass()) {//2个都是相同的可比较的具体类型，则按自然比较函数
            Comparator c = Comparator.naturalOrder();
            return Objects.compare(a1, a2, c);
        } else if (a1 == null && a2 != null) {//有且只有一个为空值时，空值按小值对待
            return -1;
        } else if (a1 != null && a2 == null) {//有且只有一个为空值时，空值按小值对待
            return 1;
        } else if (a1 != null && a2 != null) {//2者都不为空时，
            if (a1 instanceof CharSequence || a2 instanceof CharSequence) {//至少有一个对象是字符串系列，则按字符串比较
                return String.valueOf(a1).compareTo(String.valueOf(a2));
            } else {//否则按哈希比较
                return Integer.compare(a1.hashCode(), a2.hashCode());
            }
        } else {
            throw new UnsupportedOperationException("不应该还有进入到这里的情况。如果你看到我说明有遗漏的情况。");
        }
    }

    public static <A> Comparator<A> AnyComparator() {
        return GonglerUtil::CompareAny;
    }

    ////////////////////////////////////////////////////////////////////////////
    public static InputStream FilterInputStream(InputStream in, IntUnaryOperator func) {//gongler20180909add
        return new FilterInputStream(in) {
            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ch = this.read();
                if (ch == -1) {
                    throw new EOFException();
                }
                b[0] = (byte) func.applyAsInt(ch);
                return 1;
            }
        };
    }

    public static OutputStream FilterOutputStream(OutputStream out, IntUnaryOperator func) {//gongler20180909add
        return new FilterOutputStream(out) {
            @Override
            public void write(int b) throws IOException {
                super.write(func.applyAsInt(b));
            }
        };
    }

    ///////////////////////////////////////////////////////////////////////////////////
    //根据上下边界值约束返回值

    public static int IntForceRange(int val, int min, int max) {//gongler20190403add
        if (val < min) {
            return min;
        } else if (val > max) {
            return max;
        } else {
            return val;
        }
    }

    public static int UnsignedIntForceRange(int val, int min, int max) {//gongler20190403add
        return (int) LongForceRange(((long) val) & 0xFFFFFFFFL, ((long) min) & 0xFFFFFFFFL, ((long) max) & 0xFFFFFFFFL);
    }

    public static long LongForceRange(long val, long min, long max) {//gongler20190403add
        if (val < min) {
            return min;
        } else if (val > max) {
            return max;
        } else {
            return val;
        }
    }

    public static LocalDateTime ForceToLocalDateTime(int year, int month, int day, int hour, int minute, int second) {//gongler20190403add
        year = IntForceRange(year, 0, 9999);
        month = IntForceRange(month, 1, 12);
        day = IntForceRange(day, 1, daysOfMonth(year, month));
        hour = IntForceRange(hour, 0, 23);
        minute = IntForceRange(minute, 0, 59);
        second = IntForceRange(second, 0, 59);
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public static LocalDate ForceToLocalDate(int year, int month, int day) {//gongler20190403add
        year = IntForceRange(year, 0, 9999);
        month = IntForceRange(month, 1, 12);
        day = IntForceRange(day, 1, daysOfMonth(year, month));
        return LocalDate.of(year, month, day);
    }

    public static int daysOfMonth(int year, int month) {//gongler20190403add
        LocalDateTime from = LocalDateTime.of(year, month, 1, 0, 0, 0), to = from.plusMonths(1);
        return (int) Duration.between(from, to).toDays();
    }

    ////////////////////////////////////////////////////////////////////////////
    //会抛出异常的断言
    public static boolean require(boolean val) {
        return require(val, "requireTrue");
    }

    public static boolean require(boolean val, String msg) {
        if (!val) {
            throw new IllegalArgumentException(msg);
        }
        return val;
    }


    private static String assertMessage(Object expected, Object actual) {
        return "expected: " + expected + ", but actual: " + actual;
    }

    private static String assertMessage(Object expected, Object actual, String msg) {
        return "expected: " + expected + ", but actual: " + actual + ", " + msg;
    }

    public static <T> void requireEquals(T expected, T actual) {
        if (!Objects.equals(expected, actual)) throw new IllegalArgumentException(assertMessage(expected, actual));
    }

    public static <T> void requireEquals(T expected, T actual, String msg) {
        if (!Objects.equals(expected, actual)) throw new IllegalArgumentException(assertMessage(expected, actual, msg));
    }

    public static void requireEquals(int expected, int actual) {
        if (expected != actual) throw new IllegalArgumentException(assertMessage(expected, actual));
    }

    public static void requireEquals(long expected, long actual) {
        if (expected != actual) throw new IllegalArgumentException(assertMessage(expected, actual));
    }

    public static void requireLessThenOrEqual(int val, int limit) {
        if (!(val <= limit)) throw new IllegalArgumentException(val + "应小于或等于限定值" + limit);
    }

    public static void requireLessThenOrEqual(long val, long limit) {
        if (!(val <= limit)) throw new IllegalArgumentException(val + "应小于或等于限定值" + limit);
    }

    public static void requireLessThen(int val, int limit) {
        if (!(val < limit)) throw new IllegalArgumentException(val + "应小于限定值" + limit);
    }

    public static void requireLessThen(long val, long limit) {
        if (!(val < limit)) throw new IllegalArgumentException(val + "应小于限定值" + limit);
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) throw new NullPointerException();
        return obj;
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) throw new NullPointerException(message);
        return obj;
    }

    public static int requireIntRange(int val, int min, int max) {//gongler20190403add
        if (val < min || val > max) {
            throw new IllegalArgumentException("" + val + " not in " + "[" + min + ", " + max + "]");
        } else {
            return val;
        }
    }

    public static long requireLongRange(long val, long min, long max) {//gongler20190403add
        if (val < min || val > max) {
            throw new IllegalArgumentException("" + val + " not in " + "[" + min + ", " + max + "]");
        } else {
            return val;
        }
    }

    ////////////////////////////////////////////////////////////////
    //
    static class SimpleArrayList<E> extends ArrayList<E> {
        @Override
        public E get(int index) {
            index = index >= 0 ? index : size() + index;
            return super.get(index);
        }

        @Override
        public String toString() {
            return super.toString();
        }

    }
    ////////////////////////////////////////////////////////////////////////////
    //快捷创建集合

    /**
     * 可以规避放入不可比较的元素
     *
     * @param <K> key
     * @param <V> value
     * @return Map
     */
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {//20180823add确保元素可比较
        return new TreeMap<>();
    }

    public static <K, V> HashMap<K, V> newHashMap() {//2022年10月27日
        return new HashMap<>();
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {//2022年10月27日
        return new HashMap<>(expectedSize*4/3+1);
    }

    /**
     * 可以规避放入不可比较的元素
     *
     * @param <K> key
     * @param <V> value
     * @return Map
     */
    public static <K extends Comparable, V> ConcurrentSkipListMap<K, V> newConcurrentSkipListMap() {//20180823add确保元素可比较
        return new ConcurrentSkipListMap<>();
    }

    /**
     * 可以规避放入不可比较的元素
     *
     * @param <K> Key
     * @return TreeSet
     */
    public static <K extends Comparable> TreeSet<K> newTreeSet() {//20180823add确保元素可比较
        return new TreeSet<>();
    }

    public static <T> List<T> newArrayList() {//20160919add
        return new ArrayList<>();
    }

    public static <T> LinkedList<T> newLinkedList() {//20160919add
        return new LinkedList<>();
    }

    public static <T> List<T> newList(int size, ExceptionIntFunction<T> func) {
        List<T> list = new ArrayList<>();
        Repeat(size, i -> list.add(func.toFunction().apply(i)));
        return list;
    }

    public static <T> List<T> newList(int size) {//2022年10月30日
        List<T> list = new ArrayList<>();
        Repeat(size, i -> list.add(null));
        return list;
    }


    /**
     * 可以规避放入不可比较的元素
     *
     * @param <K> Key
     * @return set
     */
    public static <K extends Comparable> ConcurrentSkipListSet<K> newConcurrentSkipListSet() {//20180823add确保元素可比较
        return new ConcurrentSkipListSet<>();
    }


    ////////////////////////////////////////////////////////////////////////////
    //集合：forEach

    /**
     * 和Map.forEach()相比，可以在forEach操作之前，做些处理：过滤、筛选等。
     *
     * @param <K>    key
     * @param <V>    value
     * @param map    map
     * @param mapper mapper
     * @param action action
     */
    public static <K, V> void MapForEach(Map<K, V> map, UnaryOperator<Stream<Map.Entry<K, V>>> mapper, BiConsumer<K, V> action) {
        mapper.apply(map.entrySet().stream()).forEach(e -> action.accept(e.getKey(), e.getValue()));
    }

    public static <K, V> void MapForEachLimit(Map<K, V> map, long limit, BiConsumer<K, V> action) {//20160913add
        MapForEach(map, stream -> stream.limit(limit), action);
    }

    public static <K extends Comparable, V> void MapForEachOrdered(Map<K, V> map, BiConsumer<? super K, ? super V> action) {//20180817add
        if (map instanceof SortedMap) {
            map.forEach(action);
        } else {
            new TreeMap<>(map).forEach(action);
        }
    }

    /**
     * 为Map添加排序枚举
     *
     * @param <K>        key
     * @param <V>        value
     * @param map        map
     * @param comparator comparator
     * @param action     action
     */
    public static <K, V> void MapForEachOrdered(Map<K, V> map, Comparator<? super K> comparator, BiConsumer<? super K, ? super V> action) {//20180817add
        Map<K, V> ret = new TreeMap<>(comparator);
        ret.putAll(map);
        ret.forEach(action);
    }

    //    public static <T> List<T> Sort(List<T> list, Comparator<? super T> c) {//20170330不频繁调用，例如：页面  * 2017.03.30 add Util.Sort(), PrefixLinenameComparator
//        //debug list.sort(c);
//        List<T> ret = new ArrayList<>(list);
//        ret.sort(c);
//        return ret;
//    }
//
//    public static <T> List<T> Sort(List<T> arg, Function<? super T, ? extends Comparable> keyExtractor) {//20170330不频繁调用，例如：页面
//        return Sort(arg, Comparator.comparing(keyExtractor));
//    }
//
//    public static <T> Collection<T> Sort(Collection<T> list, Comparator<? super T> c) {//gongler20171124add
//        Set<T> ret = new TreeSet<>(c);
//        ret.addAll(list);
//        return ret;
//    }
//
//    public static <T> SortedSet<T> Sort(Set<T> arg, Comparator<? super T> c) {//20170330不频繁调用，例如：页面
//        SortedSet<T> ret = new TreeSet<>(c);
//        ret.addAll(arg);
//        return ret;
//    }
//
//    public static <T> SortedSet<T> Sort(Set<T> arg, Function<? super T, ? extends Comparable> keyExtractor) {//20170330不频繁调用，例如：页面
//        return Sort(arg, Comparator.comparing(keyExtractor));
//    }
    public static <T> Collection<T> Sort(Iterable<T> collect, Comparator<? super T> c) {//20180913
        if (collect instanceof Set) {
            SortedSet<T> ret = new TreeSet<>(c);
            for (T e : collect) {
                ret.add(e);
            }
            return ret;
        } else {//有可能类似List，允许重复记录
            List<T> ret = new ArrayList<>();
            for (T e : collect) {
                ret.add(e);
            }
            Collections.sort(ret, c);
            return ret;
        }
    }

    public static <T extends Comparable> Collection<T> Sort(Iterable<T> collect) {//20180913
        if (collect instanceof Set) {
            SortedSet<T> ret = new TreeSet<>();
            for (T e : collect) {
                ret.add(e);
            }
            return ret;
        } else {//有可能类似List，允许重复记录
            List<T> ret = new ArrayList<>();
            for (T e : collect) {
                ret.add(e);
            }
            Collections.sort(ret);
            return ret;
        }
    }

    public static <T> Collection<T> Sort(Iterable<T> arg, Function<? super T, ? extends Comparable> keyExtractor) {//gongler20171124add
        return Sort(arg, Comparator.comparing(keyExtractor));
    }

    public static <T, K> SortedMap<K, T> Sort(Map<K, T> arg, Comparator<? super K> c) {//20170330不频繁调用，例如：页面
        SortedMap<K, T> ret = new TreeMap<>(c);
        ret.putAll(arg);
        return ret;
    }

    public static <T, K> SortedMap<K, T> Sort(Map<K, T> arg, Function<? super K, ? extends Comparable> keyExtractor) {//20170330不频繁调用，例如：页面
        return Sort(arg, Comparator.comparing(keyExtractor));
    }

    ////////////////////////////////////////////////////////////////////////////
    //集合增强

    /**
     * ArrayList增强的ArrayList，支持负值index（从尾部开始数，-1代表最后一个元素）
     *
     * @param <E> 元素类型
     * @return 增强的list
     */
    public static <E> List<E> minusIndexableList() {//2022年10月6日
        return new SimpleArrayList<>();
    }

    /**
     * @param list 原始列表
     * @param <E>  元素类型
     * @return 增强的list
     */
    public static <E> List<E> minusIndexableList(List<E> list) {//2022年10月6日
        SimpleArrayList<E> ins = new SimpleArrayList<>();
        ins.addAll(list);
        return ins;
    }

    public static <T> T LastItem(List<T> list) {
        if (list.isEmpty()) {
            return null;
        } else {
            return list.get(list.size() - 1);
        }
    }

    public static <T> T LastItem(T[] list) {
        if (list.length == 0) {
            return null;
        } else {
            return list[list.length - 1];
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    //集合翻转

    /**
     * 在不改变原列表的前提前提供翻转的列表
     *
     * @param srcList src list
     * @param <E>     element
     * @return reverse list
     */
    public static <E> List<E> Reverse(List<E> srcList) {//20160727
        List<E> dest = new ArrayList<>(srcList);
        Collections.reverse(dest);
        return dest;
    }

    /**
     * 在不改变原数组的前提前提供翻转的数组
     *
     * @param src 原始数组
     * @return 翻转的数组
     */
    public static byte[] Reverse(byte[] src) {//20160727
        final int len = src.length;
        byte[] dst = Arrays.copyOf(src, len);
        for (int i = len / 2; i >= 0; i--) {
            byte tmp = dst[i];
            dst[i] = dst[len - 1 - i];
            dst[len - 1 - i] = tmp;
        }
        return dst;
    }

    public static <T> T[] Reverse(T[] src) {//20160727
        final int len = src.length;
        T[] dst = Arrays.copyOf(src, len);
        for (int i = len / 2; i >= 0; i--) {
            T tmp = dst[i];
            dst[i] = dst[len - 1 - i];
            dst[len - 1 - i] = tmp;
        }
        return dst;
    }

    ////////////////////////////////////////////////////////////////////////////
    //数据库

    public static void Close(AutoCloseable closeable) {//20160719add
        if (closeable != null) {
            try {
                closeable.close();
            } catch (Exception ex) {
            }
        }
    }

    /**
     * 可以给关闭方法不叫close()的类增加try自动关闭的能力。例如Graph3D
     *
     * @param closeTask 注册结尾要关闭的事项
     * @return AutoCloseable result
     */
    public static AutoCloseable AutoCloseable(ITask closeTask) {//gongleradd 2022年2月10日
        return closeTask::run;
    }

    public static void Rollback(Connection conn) {
        if (conn != null) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            } catch (Exception ex2) {
            }
        }
    }

    public static void Commit(Connection conn) throws SQLException {
        if (conn != null) {
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    //杂项

    public static TimerTask TimerTask(ITask task) {//20160719add
        return new TimerTask() {
            @Override
            public void run() {
                ExecuteWithCatchAny(task);
            }
        };
    }

    public static <T> Comparator<T> HashComparator() {
        return Comparator.comparingInt(Object::hashCode);
    }

    public static boolean IsLinux() {//gongler20190627
        return "Linux".equalsIgnoreCase(System.getProperty("os.name"));
    }

    public void ImportPropertiesToSystemIfNoExisted(Properties prop) {//2016.08.24add只导入不存在的键值对，禁止覆盖已有的系统值。
        for (String key : prop.stringPropertyNames()) {
            if (System.getProperty(key) == null) {
                System.setProperty(key, prop.getProperty(key));
            } else {
                new IllegalArgumentException("Can not replace system propertiy " + key + "=" + System.getProperty(key) + " -> " + prop.getProperty(key)).printStackTrace();
            }
        }
    }

}
