/*
 *
 *
 *
 */
package cn.gongler.util.tuple;

import java.util.Arrays;

/**
 * 返回不限数量的项，但是类型是一样的。
 *
 * @author gongler
 */
public class TupleArray {

    private static final long serialVersionUID = 6856576024419922833L;//TupleArray @since 2016-09-08

    Object[] array;

    public static TupleArray of(Object... array) {
        TupleArray instance = new TupleArray();
        instance.array = array;
        return instance;
    }

    public Object get(int pos) {
        int index = pos - 1;
        return array[index];
    }

    public <X> X get(int pos, Class<X> aClass) {
        return (X) get(pos);
    }

    public String getString(int pos) {
        return (String) get(pos);
    }

    public Boolean getBoolean(int pos) {
        return (Boolean) get(pos);
    }

    public Long getLong(int pos) {
        return (Long) get(pos);
    }

    public Integer getInteger(int pos) {
        return (Integer) get(pos);
    }

    public Boolean getShort(int pos) {
        return (Boolean) get(pos);
    }

    public Byte getByte(int pos) {
        return (Byte) get(pos);
    }

    public Double getDouble(int pos) {
        return (Double) get(pos);
    }

    public Float getFloat(int pos) {
        return (Float) get(pos);
    }

    public byte[] getBytes(int pos) {
        return (byte[]) get(pos);
    }

    public int size() {
        return array.length;
    }

    @Override
    public String toString() {
        return Arrays.toString(array);
    }
}
