/*
 */
package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.LineUpDown;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 线路内单边站点序列
 *
 * @author gongler
 */
public class LineSide implements Iterable<LineBusstop> {

    private static final long serialVersionUID = 5382729041582482645L;//2017-09-13 LineSide

    public static LineSide NULL = new LineSide();

    //BusSubline refBusSubline;
    LineUpDown upDown;

    //    public LineSide(BusSubline line, boolean upDown){
//        this.refBusSubline = line;
//        this.upDown = upDown;
//    }
    public LineSide() {
        this(LineUpDown.LINE_UP);
    }

    public LineSide(LineUpDown upDown) {
        this.upDown = upDown;
    }

    //    public BusSubline getBusSubline(){
//        return refBusSubline;
//    }
    final List<LineBusstop> busstopList = new ArrayList<>();

    public void loadBusstops(List<LineBusstop> busstops) {
        busstopList.clear();
        this.busstopList.addAll(busstops);
    }

    public void appendBusstop(LineBusstop nextBusstop) {
        nextBusstop.setBusstopSerial(busstopList.size() + 1);
        this.busstopList.add(nextBusstop);
    }

    public LineBusstop checkNextBusstop(IGps gps, int busstopSerial, Connection conn) throws SQLException {
        final LineBusstop last = this.getBusstopBySerial(busstopSerial);//getLastBusstop(bus);
        final int lastIndex = busstopList.indexOf(last);
        int fromIndex = (lastIndex >= 0) ? lastIndex + 1 : 0;

        for (int i = fromIndex; i < busstopList.size(); i++) {
            LineBusstop busstop = busstopList.get(i);
            if (busstop.inside(gps, conn)) {
                return busstop;
            }
        }

        for (int i = 0; i < lastIndex; i++) {
            LineBusstop busstop = busstopList.get(i);
            if (busstop.inside(gps, conn)) {
                return busstop;
            }
        }

        return null;
    }

    //    private LineBusstop getLastBusstop(ILineBus bus) {
//        return bus.getLastBusstop();
//    }
    public int getBusstopCnt() {
        return busstopList.size();
    }

    public int getBusstopSerial(LineBusstop nextBusstop) {
        return nextBusstop.getBusstopSerial();
    }

    void clearBusstopList() {
        busstopList.clear();
    }

    private LineBusstop getBusstopBySerial(int busstopSerial) {
        int index = SerialToIndex(busstopSerial);
        if (index < 0 || index >= busstopList.size()) {
            return null;
        }
        return busstopList.get(index);
    }

    public boolean isFinalBusstop(int busstopSerial) {
        return busstopSerial == getBusstopSerialMax();
    }

    public int getBusstopSerialMax() {
        return busstopList.size();
    }

    public LineUpDown upDown() {
        return upDown;
    }

    @Override
    public String toString() {
        String builder = "\n " + this.getClass().getSimpleName() +
                "," + upDown +
                ",size=" + busstopList.size() +
                "," + busstopList;
        return builder;
    }

    @Override
    public Iterator<LineBusstop> iterator() {
        return busstopList.iterator();
    }

    static int SerialToIndex(int busstopSerial) {
        final int busstopIndex = busstopSerial - 1;
        return busstopIndex;
    }

    static int IndexToSerial(int busstopIndex) {
        final int busstopSerial = busstopIndex - 1;
        return busstopSerial;
    }

}
