/*
 */
package cn.gongler.util.sgeo.line;

import cn.gongler.util.db.DbUtil;
import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroup;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.BusFactory;
import cn.gongler.util.sgeo.gps.BusState;
import cn.gongler.util.sgeo.gps.IBusGpsListener;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.imp.*;

import javax.sql.DataSource;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import static cn.gongler.util.GonglerUtil.Close;
import static cn.gongler.util.GonglerUtil.Commit;

/**
 * 线路事件识别的入口点。 背景：石家庄聚合设备创建的简易实现。站点编号直接作为围栏ID。
 *
 * @author gongler
 * @since 2011.12.1
 */
@Deprecated
public class LineEventChecker implements IBusGpsListener, ISwitchBusLineActions {

    private static final long serialVersionUID = 1L;

    private Set<ILineEventListener> lineEventListenerSet = new HashSet<>();

    {
        lineEventListenerSet.add(new SampleLineEventListener());
    }

    private Set<IGpsListener> gpsListenerSet = new HashSet<>();

    static {
        //eventListenerSet.add(new SampleLineEventListener());
    }

    public void addLineEventListener(ILineEventListener listener) {
        this.lineEventListenerSet.add(listener);
    }

    public void addGpsListener(IGpsListener listener) {
        this.gpsListenerSet.add(listener);
    }

    public LineEventChecker(Properties pro) {
    }

    DataSource ds = null;

    //////////////////////////////////////////
    //interface IBusGpsListener
    @Override
    public void config(Properties props) {
        //load line
        //load all of bus
    }

    LowLineFactory lowlineFactory = null;

    public void init(DataSource ds) throws SQLException {
        //System.out.println("ds=" + ds);
        ScopeGroupFactory scopeFact = ScopeGroupFactory.of();
        scopeFact.connectionFactory(ds);
        //scopeFact.reloadAll();

        this.ds = ds;
        lowlineFactory = new LowLineFactory(ds);
        lowlineFactory.load();
        loadBusState(ds.getConnection());
    }

    private Connection getConn() throws SQLException {
        if (ds == null) {
            return null;
        }
        return ds.getConnection();
    }

    public void close() {
        try {
            Connection conn = getConn();
            if (conn != null) {
                saveBusState(conn);
            }
        } catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private static String GPS_DIS_KEY = "GPS_DIS_KEY";//new Object();
    private static String LAST_BUSSTOP_KEY = "LAST_BUSSTOP_KEY";//new Object();
    private static String LAST_AREA_KEY = "LAST_AREA_KEY";//new Object();

    @Override
    public void handleBusGps(final long busId, final IGps gps, final IConnContext gpsCxt) {
        Connection conn = null;
        try {
            if (ds == null) {
                return;
            }
            conn = ds.getConnection();
            if (conn == null) {
                return;
            }

            final long packTime = gps.gpsTime();

            final InetSocketAddress addr = gpsCxt.getClientAddr();
            BusState bus = BusFactory.getInstance().getBus(busId);
            //System.out.println("busState="+bus+" when gps="+gps);
            long lowlineId = bus.getLowlineId();//cxt.getLowline();
            long driverId = bus.getDriverId();

            IGpsDis gpsDis = (IGpsDis) bus.getValue(GPS_DIS_KEY);
            //System.out.println("getGpsDis: "+busId+", GpsDis"+gpsDis);
            if (gpsDis == null) {
                gpsDis = new GpsIntervalDis();
                bus.setValue(GPS_DIS_KEY, gpsDis);
                System.out.println("getGpsDis0: " + busId + ", new GpsDis" + gpsDis);
            }
            //System.out.println("getGpsDis1: "+busId+", GpsDis"+gpsDis);
            gpsDis.pushGps(gps);
            //System.out.println("getGpsDis2: "+busId+", GpsDis"+gpsDis);

            //double dis = gpsDis.getDistance();
            bus.setValue("GPS_DIS", gpsDis.getDistance());

            final LineUpDown upDown = bus.upDown();

            //System.out.println(""+gpsListenerSet);
            for (IGpsListener gpslist : gpsListenerSet) {
                gpslist.handleBusGps(bus, gps, gpsCxt);
            }

            //////////////////////////////////////////////////////////////
            //Chang check
            try {//wangtmp20110803
                AreaReachEventContext areaEventContxt = (AreaReachEventContext) bus.getValue(LAST_AREA_KEY);//lineFactory.getBusstopState(bus);
                if (areaEventContxt == null) {
                    //ScopeGroup changGroup = ScopeGroup.CHANGZHANS_SCOPEGROUP;
                    Scope nextScopeInfo = ScopeGroupFactory.of().group(ScopeGroup.CHANG_GROUPID).firstInside(gps);//.beforeAccessDb(conn)//changGroup.insideCheck(gps, conn);

                    if (nextScopeInfo != null) {
                        long changId = nextScopeInfo.num1();
                        //System.out.println("reachArea:bus" + busId + ", area" + changId);

                        areaEventContxt = new AreaReachEventContext(nextScopeInfo, gps);
                        bus.setValue(LAST_AREA_KEY, areaEventContxt);

                        for (ILineEventListener lis : lineEventListenerSet) {
                            lis.reachArea(busId, gps, changId, areaEventContxt);
                        }
                    }

                } else {
                    Scope scopeInfo = areaEventContxt.getScopeInfo();
                    boolean inside = scopeInfo.inside(gps);
                    if (inside == false) {
                        long changId = scopeInfo.num1();
                        //System.out.println("leaveArea:bus" + busId + ", area" + changId);
                        for (ILineEventListener lis : lineEventListenerSet) {
                            lis.leaveArea(busId, gps, changId, areaEventContxt);
                        }
                        bus.setValue(LAST_AREA_KEY, null);
                    }
                }
            } catch (Exception e) {//wangtmp20110803
                e.printStackTrace();
            }
            //////////////////////////////////////////////////////////////
            if (lowlineId <= 0) {
                return;//没有对应到线路
            }
            //get line
            final Lowline lowline = lowlineFactory.getLowLine(lowlineId);
            final LineSide lineSide = lowline.getLineSide(upDown);

            //System.out.println("gps Pos: " + lineSide.checkNextBusstop(gps, 0, conn));

            BusstopState busstopState = (BusstopState) bus.getValue(LAST_BUSSTOP_KEY);//lineFactory.getBusstopState(bus);
            if (busstopState == null) {
                bus.setValue(LAST_BUSSTOP_KEY, busstopState = new BusstopState());
            }

            final LineBusstop lastBusstop = busstopState.getBusstop();

            //脱线识别
            if (lowline.existLineScope(conn)) {
                final IGps leaveLineFromGps = bus.getLeaveLineGps();
                final boolean nextGpsInside = lowline.inside(gps, conn);
                ILeaveLineContext leaveLineEvent = new MyLineEventContext(lowline, lineSide, lastBusstop, driverId, gpsCxt);
                if (leaveLineFromGps == null) {
                    if (!nextGpsInside) {
                        //leave line scope
                        for (ILineEventListener lis : lineEventListenerSet) {
                            lis.leaveLine(packTime, busId, lowlineId, upDown, leaveLineEvent);
                        }
                        bus.setLeaveLineGps(gps);
                    }
                } else if (nextGpsInside) {
                    //into line scope
                    int seconds = (int) (gps.gpsTime() - leaveLineFromGps.gpsTime()) / 1000;
                    for (ILineEventListener lis : lineEventListenerSet) {
                        lis.backLine(packTime, busId, lowlineId, upDown, seconds, leaveLineEvent);
                    }
                    bus.setLeaveLineGps(null);
                }
            } else {
                //System.out.println("WARN: no line scope:" + lowline.id());
            }

            //进出站识别
            if (busstopState.isInBusstop()) {//if in busstop
                final LineBusstop curBusstop = lastBusstop;
                //System.out.println("++"+curBusstop);

                if (!curBusstop.inside(gps, conn)) {//要离开吗 
                    //System.out.println(">>>>>>>>>>>" + busId + ", " + curBusstop);
                    final long fromTime = busstopState.getFromTime();
                    //notify leaveBusstopEvent
                    final int busstopSerial = lineSide.getBusstopSerial(curBusstop);
                    final long busstopId = curBusstop.getBusstopId();
                    final int seconds = busstopState.leaveBusstop(curBusstop, gps);//bus.leaveBusstop(gps, busstop);

                    IReachBusstopContext reachBusstopEvent = new MyLineEventContext(lowline, lineSide, curBusstop, driverId, gpsCxt);
                    for (ILineEventListener lis : lineEventListenerSet) {
                        lis.leaveBusstop(packTime, busId, lowlineId, upDown, busstopSerial, busstopId, seconds, reachBusstopEvent);
                    }

                } else {
                    //System.out.println("........." + busId + ", " + curBusstop);
                }

            } else {//不在站内时 
                //System.out.println("--");
                final LineBusstop nextBusstop = lineSide.checkNextBusstop(gps, bus.getBusstopSerial(), conn);
                if (nextBusstop != null && (nextBusstop != lastBusstop)) {
                    System.out.println("reach " + nextBusstop + ", " + gps);
                    busstopState.reachBusstop(nextBusstop, gps);
                    final int busstopSerial = lineSide.getBusstopSerial(nextBusstop);
                    final long busstopId = nextBusstop.getBusstopId();

                    int lastBusstopSerial = lastBusstop != null ? lastBusstop.getBusstopSerial() : -1;
                    if (busstopSerial < lastBusstopSerial) {
                        //System.out.println(" switchLine when nextSerial<previousSerial" + nextBusstop + " " + lastBusstop);
                        LineSide newLineSide = lowline.getNextLineSide(lineSide);
                        bus.switchLine(lowline.id(), newLineSide.upDown());
                        bus.setValue(LAST_BUSSTOP_KEY, null);

                    } else if (busstopSerial > lastBusstopSerial) {
                        //reachBusstopEvent
                        //System.out.println("<<<<<<<<<<<<" + busId + ", " + nextBusstop);
                        IReachBusstopContext reachBusstopEvent = new MyLineEventContext(lowline, lineSide, nextBusstop, driverId, gpsCxt);
                        for (ILineEventListener lis : lineEventListenerSet) {
                            //if(busstopSerial==1) continue;//忽略起始站进站
                            lis.reachBusstop(packTime, busId, lowlineId, upDown, busstopSerial, busstopId, reachBusstopEvent);
                        }

                        if (lineSide.isFinalBusstop(busstopSerial)) {
                            //System.out.println(" switchLine at FinalBusstop" + nextBusstop);
                            LineUpDown newUp = lowline.getNextLineSide(lineSide).upDown();
                            bus.switchLine(lowline.id(), newUp);
                            bus.setValue(LAST_BUSSTOP_KEY, null);
                            saveBusLine(conn, busId, lowlineId, newUp, gps.gpsTime());
                        }
                    }

                }

            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException ex) {
                }
            }
        }
    }

    static class MyLineEventContext implements IReachBusstopContext, ILeaveLineContext {

        private static final long serialVersionUID = 1L;


        Lowline lowline;
        LineSide lineSide;
        LineBusstop nextBusstop;
        long driverId = 0;
        IConnContext gpsCxt;

        private MyLineEventContext(Lowline lowline, LineSide lineSide, LineBusstop nextBusstop, long driverId, IConnContext gpsCxt) {
            this.lowline = lowline;
            this.lineSide = lineSide;
            this.nextBusstop = nextBusstop;
            this.driverId = driverId;
            this.gpsCxt = gpsCxt;
        }

        @Override
        public LineBusstop getBusstop() {
            return nextBusstop;
        }

        @Override
        public Lowline getLowline() {
            return lowline;
        }

        @Override
        public LineUpDown upDown() {
            return lineSide.upDown();
        }

        @Override
        public LineSide getLineSide() {
            return lineSide;
        }

        @Override
        public long getBusId() {
            return gpsCxt.getBusId();
        }

        @Override
        public long getDriverId() {
            return driverId;
        }

        @Override
        public InetSocketAddress getClientAddr() {
            return gpsCxt.getClientAddr();
        }

        @Override
        public long getTime() {
            return gpsCxt.getTime();
        }

        @Override
        public IGps getGps() {
            return gpsCxt.getGps();
        }

        @Override
        public String toString() {
            String builder = "backLine: " + lowline.id() +
                    ", " + lineSide.upDown() +
                    ", " + nextBusstop +
                    ", " + gpsCxt;
            return builder;
        }

        @Override
        public Object getProperty(Object key) {
            return gpsCxt.getProperty(key);
        }

        @Override
        public void setProperty(Object key, Object val) {
            gpsCxt.setProperty(key, val);
        }
    }

    @Override
    public void registed() {
    }

    @Override
    public void unregisted() {
    }

    //////////////////////////////////////////
    //interface ISwitchBusLineActions
    @Override
    public boolean switchBusLine(long busId, long lowlineId, LineUpDown upDown) {
        BusState bus = BusFactory.getInstance().getBus(busId);
        LineSide lineSide = lowlineFactory.getLineSide(lowlineId, upDown);
        if (lineSide != null) {
            bus.switchLine(lowlineId, upDown);
            Connection conn = null;
            try {
                conn = ds.getConnection();
                saveBusLine(conn, busId, lowlineId, upDown, System.currentTimeMillis());
                //System.out.println("外部切换线路成功: " + lowlineId + ", " + upDown);
            } catch (SQLException ex) {
                ex.printStackTrace();
            } finally {
                Close(conn);
            }
            return true;
        } else {
            //System.out.println("Warn: 要切换的线路不存在: " + lowlineId + ", " + upDown);
            return false;
        }
    }

    @Override
    public boolean switchBusDriverId(long busId, long driverId) {
        BusState bus = BusFactory.getInstance().getBus(busId);
        bus.setDriverId(driverId);
        Connection conn = null;
        try {
            conn = ds.getConnection();
            saveDriverId(conn, busId, driverId);
            //System.out.println("外部切换司机成功: " + driverId);
        } catch (SQLException ex) {
            ex.printStackTrace();
        } finally {
            Close(conn);
        }
        return true;

    }

//    @Override
//    public boolean reloadLineScope(long lowlineId) {
//        ScopeGroupFactory.of().removeScope(lowlineId);//20160928 延迟载入。
//        return true;
//    }

//-- Create table
//create table GPS_BUS_STATE
//(
//  BUS_NO     NUMBER(20) not null,
//  LOWLINE_NO NUMBER(20) default 0 not null,
//  UPDOWN     NUMBER(3) default 0 not null,
//  UTIME      DATE default SYSDATE
//);
//-- Add comments to the table 
//comment on table GPS_BUS_STATE
//  is '虚拟车台状态';
//-- Add comments to the columns 
//comment on column GPS_BUS_STATE.UTIME
//  is 'UPDATE TIME';
//-- Create/Recreate primary, unique and foreign key constraints 
//alter table GPS_BUS_STATE
//  add constraint PK_GPS_BUS_STATE primary key (BUS_NO)
//;

    /**
     * * @param connection
     *
     * @throws SQLException
     */
    private void loadBusState(Connection connection) throws SQLException {
        DbUtil.ExecuteQuery(connection, "SELECT * FROM GPS_BUS_STATE ORDER BY BUS_NO", (ResultSet rs, int rowIndex) -> {
            long busId = rs.getLong("BUS_NO");
            long lowlineId = rs.getLong("LOWLINE_NO");
            int updown = rs.getInt("UPDOWN");//0:up 1:down
            long driverId = rs.getLong("DRIVER_NO");
            Timestamp datetime = rs.getTimestamp("UTIME");//0:up 1:down
            double distance = rs.getDouble("GPS_DIS");
            //System.out.println("load " + busId + ", " + lowlineId + ", " + updown + ", " + datetime + ", " + distance);
            LineUpDown upDown = LineUpDown.parse(updown);
            BusState busState = BusFactory.getInstance().getBus(busId);
            busState.switchLine(lowlineId, upDown);
            busState.setDriverId(driverId);
        });

        for (BusState bus : BusFactory.getInstance().getIterator()) {
            //System.out.println("loaded: " + bus);
        }

    }

    private void saveBusLine(Connection conn, long busId, long lowlineId, LineUpDown upDown, long time) throws SQLException {
        int updown = upDown.ordinal();
        //System.out.println("save " + busId + ", " + lowlineId + ", " + updown + ", " + new Date(time));
        int cnt = DbUtil.ExecuteUpdate(conn, "update gps_bus_state set lowline_no=?, updown=?, utime=? where bus_no=? ", lowlineId, updown, new Timestamp(time), busId);
        if (cnt == 0) {
            DbUtil.ExecuteUpdate(conn, "insert into gps_bus_state(bus_no, lowline_no, updown, utime) values(?, ?, ?, ?) ", busId, lowlineId, updown, new Timestamp(time));
            //System.out.println("insert " + busId + ", " + lowlineId + ", " + updown + ", " + new Date(time));
        }
        Commit(conn);
    }

    private void saveDriverId(Connection conn, long busId, long driverId) throws SQLException {
        //System.out.println("saveDriverId " + busId + ", " + driverId);
        int cnt = DbUtil.ExecuteUpdate(conn, "update gps_bus_state set driver_no=? where bus_no=? ", driverId, busId);
        //System.out.println("saveDriverId " + busId + ", " + driverId + ", " + cnt);
        Commit(conn);
    }

    private void saveBusState(Connection conn) throws SQLException {
        for (BusState bus : BusFactory.getInstance().getIterator()) {
            saveBusLine(conn, bus.getBusId(), bus.getLowlineId(), bus.upDown(), System.currentTimeMillis());
        }
    }

    static class SampleLineEventListener implements ILineEventListener {

        private static final long serialVersionUID = 1L;


        @Override
        public void reachBusstop(long time, long busId, long lowlineId, LineUpDown upDown, int busstopSerial, long busstopId, IReachBusstopContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("reachBusstop: ").append(time)
                    .append(", ").append(busId)
                    .append(", ").append(lowlineId)
                    .append(", ").append(upDown)
                    .append(", ").append(busstopSerial)
                    .append(", ").append(busstopId)
                    .append(", ").append(cxt);
            //System.out.println(builder.toString());
        }

        @Override
        public void leaveBusstop(long time, long busId, long lowlineId, LineUpDown upDown, int busstopSerial, long busstopId, int seconds, IReachBusstopContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("leaveBusstop: ").append(time)
                    .append(", ").append(busId)
                    .append(", ").append(lowlineId)
                    .append(", ").append(upDown)
                    .append(", ").append(busstopSerial)
                    .append(", ").append(busstopId)
                    .append(", ").append(seconds)
                    .append(", ").append(cxt);
            //System.out.println(builder.toString());
        }

        @Override
        public void leaveLine(long time, long busId, long lowlineId, LineUpDown upDown, ILineEventContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("leaveLine: ").append(time)
                    .append(", ").append(busId)
                    .append(", ").append(lowlineId)
                    .append(", ").append(upDown)
                    .append(", ").append(cxt);
            //System.out.println(builder.toString());
        }

        @Override
        public void backLine(long time, long busId, long lowlineId, LineUpDown upDown, int seconds, ILineEventContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("backLine: ").append(time)
                    .append(", ").append(busId)
                    .append(", ").append(lowlineId)
                    .append(", ").append(upDown)
                    .append(", ").append(seconds)
                    .append(", ").append(cxt);
            //System.out.println(builder.toString());
        }

        @Override
        public void reachArea(long busId, IGps gps, long changId, IAreaReachEventContext areaEventContxt) {
            //System.out.println("");
        }

        @Override
        public void leaveArea(long busId, IGps gps, long changId, IAreaReachEventContext areaEventContxt) {
            //System.out.println("");
        }
    }

    private static class AreaReachEventContext implements IAreaReachEventContext {

        private static final long serialVersionUID = 1L;


        Scope scopeInfo;
        private final IGps reachGps;

        private AreaReachEventContext(Scope scopeInfo, IGps gps) {
            this.scopeInfo = scopeInfo;
            this.reachGps = gps;
        }

        @Override
        public Scope getScopeInfo() {
            return scopeInfo;
        }

        @Override
        public long getReachTime() {
            return reachGps.gpsTime();
        }

    }

}
