/*
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.sgeo.geo.IGeoPoint;

import java.sql.Timestamp;
import java.time.LocalDateTime;

/**
 * 对应一个GPS定位单元
 *
 * @author gongler
 */
public interface IGps extends IGeoPoint {

    long gpsTime();

    int gpsAngle();

    int gpsSpeed();

    default LocalDateTime localDateTime() {//20160919add
        return new Timestamp(gpsTime()).toLocalDateTime();
    }

    default Timestamp timestamp() {//20160919add
        return new Timestamp(gpsTime());
    }

    static IGps of(long time, double geoL, double geoB, int angle, int speed) {//20160919add
        return new Gps(time, geoL, geoB, angle, speed);
    }
}
