/*
 */
package cn.gongler.util.sgeo.gps;

import java.sql.Timestamp;

/**
 * @author gongler
 */
class Gps implements IGps {

    private static final long serialVersionUID = 308455961378186L;//2017-09-13 Gps

    private final int speed;
    private final int angle;
    private final double lng;//经度 Longitude
    private final double lat;//纬度 latitude
    private final long time;

    public Gps(long time, double lng, double lat, int angle, int speed) {
        this.time = time;
        this.lng = lng;
        this.lat = lat;
        this.angle = angle;
        this.speed = speed;
    }

    @Override
    public long gpsTime() {
        return time;
    }

    @Override
    public double gpsLng() {
        return lng;
    }

    @Override
    public double gpsLat() {
        return lat;
    }

    @Override
    public int gpsSpeed() {
        return speed;
    }

    @Override
    public int gpsAngle() {
        return angle;
    }

    @Override
    public String toString() {
        return "Gps" +
                "," + new Timestamp(time) +
                "," + String.format("%.6f", lng) +
                "," + String.format("%.6f", lat) +
                "," + speed +
                "," + angle;
    }

}
