/*
 *
 *
 *
 */
package cn.gongler.util.sgeo.gps;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

/**
 * GPS每1024周进行一次翻转。针对UTC 2019年4月6日24:00可能出现的翻转错误，开发本容错工具类
 * http://www.21ic.com/news/rf/201903/882376.htm
 *
 * @author gongler
 * @since 2019.04.01
 */
public class GPS20190406Util {

    private static final long serialVersionUID = 1L;

    private GPS20190406Util() {
    }

    public static final LocalDateTime DT1980_01_06_0800 = OffsetDateTime.parse("1980-01-06T00:00Z").atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();//LocalDateTime.of(1980, 1, 6, 8, 0);
//    public static LocalDateTime DT1999_08_22 = LocalDateTime.of(1999, 8, 22, 8, 0);
//    public static final LocalDateTime DT2019_04_07 = OffsetDateTime.parse("2019-04-07T00:00Z").atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();//LocalDateTime.of(2019, 4, 7, 8, 0);
//    public static LocalDateTime DT2038_11_21 = LocalDateTime.of(2038, 11, 21, 8, 0);

    /**
     * 依赖服务器时钟，对GPS日期时间翻转BUG做自动校正。
     *
     * @param org 初始时间
     * @return 修正后时间
     */
    public static LocalDateTime CorrectGpsTime(LocalDateTime org) {
        return CorrectGpsTime(org, LocalDateTime.now());
    }

    /**
     * 为了方便测试。当前日期时间可以作为参数传入
     *
     * @param org 初始时间
     * @param now LocalDateTime.now()
     * @return 载入的时间
     */
    public static LocalDateTime CorrectGpsTime(LocalDateTime org, LocalDateTime now) {
        long orgCircles = Duration.between(DT1980_01_06_0800, org).toDays() / 7L / 1024L;
        long nowCircles = Duration.between(DT1980_01_06_0800, now).toDays() / 7L / 1024L;
        if (orgCircles != nowCircles) {//如果设备日期与服务器日期不处于统一循环
            if (Math.abs(Duration.between(org, now).toDays()) < 365L * 9L) {//gongler20190410 19/2年内不做翻转周期调整，否则更远离今天日期 < 365L改为 < 365L * 9//如果日期接近，属于周期跳变过程的正常现象，不应修正。
            } else {//如果日期差超过
                long deltaDays = (nowCircles - orgCircles) * 1024L * 7L;
                return org.plusDays(deltaDays);
            }
        }
        return org;
    }
//    public static void main(String[] args) {
//        LocalDateTime now = LocalDateTime.now();
//        LocalDateTime packTime = LocalDateTime.of(2001, 10, 15, 10, 10);
//        LocalDateTime ret = CorrectGpsTime(packTime, now);
//        System.out.println(""+ret);
//    }
}
