/*
 */
package cn.gongler.util.sgeo.gps;

/**
 * @author gongler
 */
class AreaOverspeedEvent {

    private static final long serialVersionUID = 1L;


    public long areaId;
    public int minSpeed;
    public int maxSpeed;
    public boolean isStart;
    public long howlong;

    @Override
    public String toString() {
        return "AreaOverspeedEvent" + areaId +
                ", " + isStart +
                ", mix" + minSpeed +
                ", max" + maxSpeed +
                ", s" + howlong;
    }

    public static class Builder {//20170912gongleradd

        public static Builder of() {
            return new Builder();
        }

        private final AreaOverspeedEvent ins = new AreaOverspeedEvent();

        Builder scopeId(long scopeId) {
            ins.areaId = scopeId;
            return this;
        }

        Builder minSpeed(int param) {
            ins.minSpeed = param;
            return this;
        }

        Builder maxSpeed(int param) {
            ins.maxSpeed = param;
            return this;
        }

        Builder seconds(long param) {
            ins.howlong = param;
            return this;
        }

        Builder isStart(boolean param) {
            ins.isStart = param;
            return this;
        }

        AreaOverspeedEvent build() {
            return ins;
        }

        @Override
        public String toString() {
            return "AreaOverspeedEvent.Builder:" + ins;
        }

    }
}
