/*
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroup;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

import static cn.gongler.util.GonglerUtil.Close;
import static cn.gongler.util.sgeo.geo.ScopeGroup.OVERSPEED_GROUPID;

/**
 * 2009嵊州receiver定制。
 *
 * @author gongler
 * @since 2009
 */
public class AreaOverspeedChecker {

    private static final long serialVersionUID = 8801167335446322705L;//2017-09-13 AreaOverspeedChecker

    private static AreaOverspeedChecker instance;

    public synchronized static AreaOverspeedChecker getInstance() {
        if (instance == null) {
            instance = new AreaOverspeedChecker();
        }
        return instance;
    }

    private AreaOverspeedChecker() {
        //System.out.println("AreaOverspeedChecker");
    }

    private ScopeGroup overspeedGroup() {//20170912gongler private final ScopeGroup overspeedGroup = ScopeGroup.OVERSPEED_SCOPEGROUP;
        return ScopeGroupFactory.of().group(OVERSPEED_GROUPID);
    }

    private static class OverspeedState {

        long fromTime = 0L;
        Scope prevOverspeedScope = null;
        private int speedMax;

        private void updateMaxSpeed(int gpsSpeed) {
            if (gpsSpeed > this.speedMax) {
                this.speedMax = gpsSpeed;
            }
        }
    }

    public void check(long busId, IGps gps, Connection conn) throws SQLException {

        BusState bus = BusFactory.getInstance().getBus(busId);
        //System.out.println(""+bus+" "+bus.hashCode());
        OverspeedState areaState = (OverspeedState) bus.map.computeIfAbsent("OverspeedState", k -> new OverspeedState());//
        long fromTime = areaState.fromTime;//
        Scope prevScope = areaState.prevOverspeedScope;
        Scope scope = overspeedGroup().firstInside(gps, s -> gps.gpsSpeed() > s.num2() || gps.gpsSpeed() < s.num1());//s.num2()最高限速; num1()最低限速（规划）

        if (prevScope == null && scope != null) {//开始超速
            AreaOverspeedEvent event = AreaOverspeedEvent.Builder.of().isStart(true).scopeId(scope.id()).build();
            dbProc(busId, gps, scope, event, conn);
            areaState.fromTime = gps.gpsTime();
            areaState.speedMax = 0;

        } else if (prevScope != null && scope == null) {//结束超速
            long seconds = (gps.gpsTime() - fromTime) / 1000L;
            AreaOverspeedEvent event = AreaOverspeedEvent.Builder.of().isStart(false).scopeId(prevScope.id()).maxSpeed(areaState.speedMax).seconds(seconds).build();
            dbProc(busId, gps, prevScope, event, conn);
        }
        areaState.prevOverspeedScope = scope;
        areaState.updateMaxSpeed(gps.gpsSpeed());
    }

    static void dbProc(long busId, IGps gps, Scope scopeInfo, AreaOverspeedEvent event, Connection conn) throws SQLException {
        //System.out.println("PRO_NETPACK_OVERSPEED: " + busId + ", " + gps + ", " + event);
        final int speedLimitedMax = (int) scopeInfo.num2();

        CallableStatement statement = null;
        try {
//PROCEDURE PK_SCOPE.EVENT_OVERSPEED( --20101215
//  I_PACK_TIME      IN TIMESTAMP,
//  I_BUS_NO         IN NUMBER,
//  I_GEO_L          IN NUMBER,
//  I_GEO_B          IN NUMBER,
//  I_SPEED          IN NUMBER,
//  I_ANGLE          IN NUMBER,
//  I_SCOPE_NO       IN NUMBER,
//  I_SPEED_LIMITED  IN NUMBER,
//  I_IS_END         IN NUMBER DEFAULT 0, --0开始（默认） 1结束
//  I_HOWLONG        IN NUMBER DEFAULT 0, --秒，开始时无意义
//  I_SPEED_HIS_MAX  IN NUMBER DEFAULT 0  --开始时无意义
//) 
            String sql = "CALL PK_SCOPE.EVENT_OVERSPEED (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";

            statement = conn.prepareCall(sql);
            int pos = 1;
            statement.setTimestamp(pos++, new Timestamp(gps.gpsTime()));//3
            statement.setLong(pos++, busId);        //1
            statement.setDouble(pos++, gps.gpsLng());//2
            statement.setDouble(pos++, gps.gpsLat());//3
            statement.setInt(pos++, gps.gpsSpeed());//4
            statement.setInt(pos++, gps.gpsAngle());//5
            statement.setLong(pos++, event.areaId);//6
            statement.setInt(pos++, speedLimitedMax);    //7
            statement.setInt(pos++, event.isStart ? 0 : 1);    //8
            statement.setLong(pos++, TimeUnit.MILLISECONDS.toSeconds(event.howlong));    //9
            statement.setInt(pos++, event.maxSpeed);//10 最大速度。废弃使用
            statement.execute();

        } finally {
            Close(statement);
        }
    }

}
