/*
 */
package cn.gongler.util.sgeo.geo;

import java.awt.geom.Point2D;

/**
 * 内部工具类(x,y)
 *
 * @author gongler
 * @since 2017.09.01
 */
interface XY {

    double x();

    double y();

    static XY of(double x, double y) {
        return new Impl(x, y);
    }

    static XY of(Point2D point) {
        return of(point.getX(), point.getY());
    }

    static XY of(IGeoPoint point) {
        return of(point.gpsLng(), point.gpsLat());
    }

    class Impl implements XY {

        private static final long serialVersionUID = 1L;//2017-09-30
        double x, y;

        private Impl(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double x() {
            return x;
        }

        @Override
        public double y() {
            return y;
        }

        @Override
        public String toString() {
            return "(" + x + "," + y + ")";
        }
    }

}
