/*
 *
 *
 */
package cn.gongler.util.sgeo.geo;

/**
 * @author gongler
 */
public interface IGeoPoint {

    /**
     * @return 经度 Longitude
     */
    double gpsLng();

    /**
     * @return 纬度 Latitude
     */
    double gpsLat();

    /**
     * 到另一个经纬度坐标的距离（单位米）
     *
     * @param another 另一个位置
     * @return 距离
     * @since 2017.09.30
     */
    default double metersTo(IGeoPoint another) {
        return GeoUtil.DisMeters(this, another);
    }


    /**
     * @param lng 经度
     * @param lat 纬度
     * @return instance
     */
    static IGeoPoint of(double lng, double lat) {//20160914add
        return new GeoPoint(lng, lat);
    }
}
