/*
 */
package cn.gongler.util.sgeo.geo;

/**
 * 经纬度地点
 *
 * @author gongler
 */
class GeoPoint implements IGeoPoint {

    private static final long serialVersionUID = 8092446122882424833L;//2017-09-30 GeoPoint

    private final double lng;//经度
    private final double lat;//纬度

    public GeoPoint(double lng, double lat) {
        this.lng = lng;
        this.lat = lat;
    }

    /**
     * @return 经度
     */
    @Override
    public double gpsLng() {
        return lng; //return D2I(pnt.x);
    }//Latitude and Longitude

    /**
     * @return 纬度
     */
    @Override
    public double gpsLat() {
        return lat; //return D2I(pnt.y);
    }

    @Override
    public String toString() {
        return "GeoPoint" + "(" + String.format("%.06f", lng) + "," + String.format("%.06f", lat) + ")";
    }


//    public static void main(String[] args) {
//        System.out.println(""+String.format("%.06f",118.114780768613));//new java.text.DecimalFormat("#.000000").format(lat);
//    }

}
