/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Scanner;

/**
 * '\0'结尾的GBK变长字符串
 *
 * @param <T> T
 * @author gongler
 */
public class StringItemType<T extends StringItemType> extends ItemType<T> {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public static final Charset CHARSET;

    static {
        String charsetName = "GBK";
        CHARSET = Charset.isSupported(charsetName) ? Charset.forName(charsetName) : Charset.defaultCharset();

    }

    /**
     *
     */
    public static StringItemType INSTANCE = new StringItemType("STRING");
    private static final String DEFAULT_VAL = "文字";

    public StringItemType(String name) {
        super(name);//super("STRING");
    }

    /**
     * @return item
     */
    @Override
    public Item create() {
        return _newItem("");//wanghg20190603debug T7_2_12_X8B02_业务变更指令 需要默认为“”//return _newItem(this.name());//20150507为了方便区分用类型名作为默认字符串值 return _newItem(DEFAULT_VAL);
    }

    @Override
    public Item load(Scanner in) {
        //wanghg20190628允许空值        String val = in.next();
        String val = "";
        try {
            val = in.next();//数量不全时，会抛出异常
        } catch (Exception e) {
        }
        return _newItem(val);
    }

    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        int maxReabable = in.remainBytesCount();
        BytesBuilder buf = BytesBuilder.of();
        for (int i = 0; i < maxReabable; i++) {
            int b = in.loadUnsignedByte();
            if (b == '\0') {//字符串结尾标志
                break;
            }
            buf.addByte(b);
        }
        byte[] bytes = buf.toBytes();
        return _newItem(newString(bytes));
    }

    /**
     * @param itemValue itemValue
     * @param build     builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof String) {
            String val = (String) itemValue;
            build.addBytes(val.getBytes(CHARSET));
        }
        build.addByte('\0');//字符串结束标记
    }

//    @Override
//    protected Object defaultValue() {
//        return DEFAULT_VAL;
//    }

    @Override
    protected Class insideValueClass() {
        return String.class;
    }

    protected String newString(byte[] bytes) {
        return new String(BytesUntilZero(bytes), CHARSET);
    }

    static byte[] BytesUntilZero(byte[] src) {

        for (int i = 0; i < src.length; i++) {
            int b = src[i];
            if (b == '\0') {//字符串结尾标志
                return Arrays.copyOf(src, i);
            }
        }
        return src;
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
//        StringItemType type = new StringItemType("name");
//        BytesBuilder build = new BytesBuilder();
//        type.toBytes("string", build);
//        System.out.println("" + build);
//    }

}
