/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author gongler
 */
public class NumberItemType extends ItemType<NumberItemType> {//public class NumberItemType<T extends NumberItemType> extends ItemType<T> {

    private static final long serialVersionUID = 1L;

    public static NumberItemType BCD(int bytes, String name) {//wanghgadd 2021年11月3日14:39:02。
        Function<Long, Long> decoder = a -> {
            long tmp = a, ret = 0;
            for (int i = 0; i < bytes * 2; i++) {
                ret = ret * 10 + (tmp & 0x0F);
                tmp >>>= 4;
            }
            return ret;
        };

        Function<Long, Long> encoder = a -> {
            long tmp = a, ret = 0;
            for (int i = 0; i < bytes * 2; i++) {
                ret = (ret << 4) + (tmp % 10);
                tmp /= 10;
            }
            return ret;
        };
        return new NumberItemType(bytes, name).decoder(decoder, encoder);
    }

    /**
     *
     */
    protected final int allBits;////wanghgadd 2021年11月2日10:07:17增加对不满字节的支持int bits = 0;////wanghgadd 2021年11月2日10:07:17增加对不满字节的支持 //protected final int bytes;
    private static final Long INIT_VAL = 0L;
    int 小数部分位数 = 0;
    long fenmu;

    private final Map<Long, String> valueNames = new HashMap();
    private String valueElseName = null;

    public NumberItemType(int bytes, String name) {
        this(bytes, 0, name);
    }

    //int bits = 0;////wanghgadd 2021年11月2日10:07:17增加对不满字节的支持
    public NumberItemType(int bytes, int bits, String name) {//wanghgadd 2021年11月2日10:07:17增加对不满字节的支持
        super(name);
        this.allBits = bytes * 8 + bits;

        if (this.allBits > 63 * 8) {//if (this.allBits > 4 * 8) {//if (bytes > 4) {
            throw new IllegalArgumentException("由于位操作是以4字节的int进行，故暂不支持大于4的字节数:" + bytes);
        }
    }

    public int bytes() {
        return this.allBits / 8;
    }

    public int bits() {
        return this.allBits % 8;
    }

    public int allBits() {
        return this.allBits;
    }


    public NumberItemType valueNote(long val, String valueNote) {
        String old = valueNames.put(val, valueNote);
        if (old != null) {
            throw new IllegalArgumentException("key is repeated: " + val);
        }
        return this;
    }

    public NumberItemType valueElseNote(String valueNote) {
        this.valueElseName = valueNote;
        return this;
    }

    public NumberItemType valueNote(Map<Long, String> valueNames) {
        this.valueNames.putAll(valueNames);
        return this;
    }

    private static boolean GetBitValue(long val, int index) {
        return (val & (1L << index)) != 0L;
    }

    private static class BitsType {//20150616wanghgadd

        final int lowBitIndex;
        final int bitCnt;
        final Map<Integer, String> bitsMap = new TreeMap();

        BitsType(int lowBitIndex, int bitCnt) {
            this.lowBitIndex = lowBitIndex;
            this.bitCnt = bitCnt;
        }

        BitsType put(int key, String bitNote) {
            bitsMap.put(key, bitNote);
            return this;
        }

        int getBitValue(long value) {
            return (int) BitGet(value, lowBitIndex, bitCnt);
        }

        String getValueNote(long itemValue) {
            int bitVal = getBitValue(itemValue);
            //System.out.println("" + itemValue + ", lowBitIndex" + lowBitIndex + ", bitCnt" + bitCnt + ", bitVal" + bitVal + ", " + bitsMap.get(bitVal) + ", " + bitsMap);
            return bitsMap.get(bitVal);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("{").append(lowBitIndex);
            if (bitCnt > 1) {
                buf.append("~").append(lowBitIndex + bitCnt);
            }
            buf.append(",").append(bitsMap).append("}");
            return buf.toString();

        }

    }

    private final Map<Integer, BitsType> bitMap = new TreeMap();//private final Map<Integer, String> bitMap = new TreeMap();

    public NumberItemType bit(int bitIndex, String trueNote) {
        if (bitIndex >= allBits) {//if (bitIndex >= (bytes * 8)) {
            throw new IllegalArgumentException("bit" + bitIndex + " > " + allBits);
        }

        BitsType instance = new BitsType(bitIndex, 1).put(1, trueNote);
        bitMap.put(bitIndex, instance);//bitMap.put(bitIndex, trueNote);
        return this;
    }

    /**
     * 调用例子： bits(8, 9, 0b00, "空车", 0b01,"半载", 0b10,"保留",
     * 0b11,"满载");
     *
     * @param lowBitIndex  低位索引
     * @param highBitIndex 包含本位
     * @param map          pairs
     * @return itemType
     */
    public NumberItemType bits(int lowBitIndex, int highBitIndex, Object... map) {//Object[] map
        BitsType instance = new BitsType(lowBitIndex, highBitIndex + 1 - lowBitIndex);
        for (int i = 0; i < map.length; i += 2) {
            Integer key = (Integer) map[i];
            String note = (String) map[i + 1];
            instance.put(key, note);
        }
        bitMap.put(lowBitIndex, instance);
        return this;
    }

    /**
     * 用于定点小数
     *
     * @param len length
     * @return itemType
     */
    public NumberItemType 小数位数(int len) {
        this.小数部分位数 = len;
        this.fenmu = (long) Math.pow(10, len);
        return this;
    }

    int 显示进制 = 10;//20150421方便16进制命令字的显示。

    public NumberItemType 显示进制(int digits) {
        this.显示进制 = digits;
        return this;
    }

    private Long defaultVal = INIT_VAL;//0L;

    public NumberItemType defaultVal(long defaultVal) {//wanghg20190531add
        this.defaultVal = defaultVal;
        return this;
    }

    /**
     * @return item
     */
    @Override
    public Item create() {
        return _newItem(defaultVal);//return new NumberItem(this, INIT_VAL);//return new NumberItem(this, INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
//wanghg20190628允许空值        long val = in.nextLong();
        long val = this.defaultVal;
        try {
            val = in.nextLong();
        } catch (Exception e) {
        }
        return _newItem(val);
    }

    //gongler 2021年10月29日，增加企业传输数据加密搅扰的解密处理。目前仅在数值类试用。
    private static final Function<Long, Long> NULL = Function.identity();
    private Function<Long, Long> decoder = NULL;//gongler 解密
    private Function<Long, Long> encoder = NULL;//gongler 加密

    /**
     * @param decoder 接收时，的解密
     * @param encoder 发送前的加密
     * @return itemType
     * 2021年10月29日
     */
    public NumberItemType decoder(Function<Long, Long> decoder, Function<Long, Long> encoder) {
        if (this.decoder == NULL) {
            this.decoder = decoder;
        } else {
            this.decoder = decoder.andThen(decoder);
        }
        if (this.encoder == NULL) {
            this.encoder = encoder;
        } else {
            this.encoder = encoder.andThen(encoder);
        }
        return this;
    }


    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        //System.out.println("before loadItem:" + in);
        long value = 0L;
        if (bits() == 0) {//字节读取模式
            for (int i = 0; i < bytes(); i++) {
                value <<= 8;
                value |= (in.loadByte() & 0xFF);
            }
        } else {//位读取模式
            value = in.loadBitsAsInt(this.allBits);
        }
        return _newItem(decoder.apply(value));
    }

    @Override
    protected Class insideValueClass() {
        return Long.class;
    }

    /**
     * @param item     item
     * @param newValue newValue
     */
    @Override
    protected void safeSetItemValue(Item item, Object newValue) {
        Long longObject = objectToLong(newValue);
        item.unsafeSetValue(longObject);
    }

    /**
     * @param itemValue itemValue
     * @param out       builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = objectToLong(itemValue);//(Long) itemValue;
        val = encoder.apply(val);//wanghgadd 新增加密环节 2021年10月29日
        if (bits() == 0) {
            out.skip(bytes());//占位
            for (int i = 1; i <= bytes(); i++) {
                out.setBack(i, (int) val & 0xFF);
                val >>= 8;
            }
            //2022年2月10日17:01:05 废弃 //要清除BytesBuilder裡面的bitValueCnt，防止寫不進去bit值
            //2022年2月10日17:01:05 废弃 out.setBitValueCnt(0);
        }
        //wangyin 2021-12-13 edit 凡是bitcount取模不等于0的，都将bit位的值加上去
        else {
            out.addBits(this.allBits, val);//字节不满时，用该方法。
            //   if(this == TiamaesItemTypes.天迈经度 || this == TableA.附表A06_压缩格式日历数据){
            //20221004 out.commitBits();
            //    }
        }
        //不需要再移动光标
    }

    /**
     * @param itemValue itemValue
     * @return long
     */
    protected long objectToLong(Object itemValue) {
        if (itemValue instanceof Number) {
            return ((Number) itemValue).longValue();
        } else {
            throw new IllegalArgumentException(itemValue == null ? "null" : itemValue.getClass().toString() + ": " + itemValue);
        }
    }

    public double toDouble(Object itemValue) {
        double doubleVal = (double) objectToLong(itemValue);
        doubleVal /= fenmu;
        return doubleVal;
    }

    public boolean isDoubleType() {
        return fenmu > 1;//有小数部分。
    }

    private static long BitGet(long oldVal, int bitIndex, int bitCount) {
        long getVal = (oldVal >> bitIndex) & (~((~0) << bitCount));
        return getVal;
    }

    private static long BitSet(long oldVal, int bitIndex, int bitCount, long bitsVal) {
        final long setVal = bitsVal << bitIndex;
        long newVal = (~((~((~0) << bitCount)) << bitIndex)) & oldVal | setVal;
        return newVal;
    }


    /**
     * @param itemValue itemValue
     * @return string
     */
    @Override
    public String toString(Object itemValue) {
        long val = objectToLong(itemValue);
        if (isDoubleType()) {//含小数时
            String ret = String.valueOf(val / fenmu) + '.' + val % fenmu;
            return ret;
        } else {//整数
            //return String.valueOf(val);
            StringBuilder ret = new StringBuilder();
            switch (显示进制) {
                case 2:
                    ret.append("0b").append(Long.toBinaryString(val));
                    break;
                case 16:
                    ret.append("0x").append(Long.toHexString(val));
                    break;
                case 10:
                default:
                    ret.append(val);
            }
            String valueName = valueNames.getOrDefault(val, valueElseName);//.get(val);
            if (valueName != null) {
                ret.append("(").append(valueName).append(")");
            }

            if (bitMap.isEmpty() == false) {//如果存在位定义
                String bitNotes = bitMap.values().stream()
                        .filter(e -> e.getBitValue(val) != 0)
                        .map(a -> a.getValueNote(val)).collect(Collectors.joining("|", "(", ")"));
                ret.append(bitNotes);
            }

            return ret.toString();
        }
    }

    //    @Override
//    protected Object defaultValue() {
//        return INIT_VAL;
//    }
    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        if (isDoubleType()) {//由于内部使用定点小数保存，故需要转换。出于不损失精度的考虑，在内部未采用Double
            double value = toDouble(item.getValue());
            statement.setDouble(pos++, value);//经纬度
        } else {
            statement.setLong(pos++, item.longValue());//经纬度
        }
        return 1;
    }

    @Override
    public double toDoubleImpl(Item item) {
        double doubleVal = (double) objectToLong(item.getValue());
        doubleVal /= fenmu;
        return doubleVal;
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }


//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
//    }
}
