/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 列表中元素是多项子元素时，隐含增加一层结构体。
 *
 * @author gongler
 */
public class ListItemType extends ItemType<ListItemType> {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    protected ItemType subItemType;//protected ItemType[] itemTypes;//20150330 未来可能为了支持动态扩展调整，改用List

    public ItemType subItemType() {
        return subItemType;
    }

    int headSize = 1;
    static final List INIT_VAL = Collections.emptyList();

    //    public ListItemType(String name, ItemType[] ItemTypeGroup) {
//        this(name, new ItemTypeStruct(name, ItemTypeGroup));//super("STRING");
//    }
//
    private static class ItemTypeStructOfList extends ItemTypeStruct {

        public ItemTypeStructOfList(String name, ItemType... itemTypes) {
            super(name, itemTypes);
        }
    }

    public static ListItemType of(String name, ItemType... subItemTypes) {
        int size = subItemTypes.length;
        if (size > 1) {//如果含多子项，则用结构体封装。
            return new ListItemType(name, new ItemTypeStructOfList(name, subItemTypes)).wrapperByStruct();
        } else if (size == 1) {
            return new ListItemType(name, subItemTypes[0]);
        } else {
            throw new IllegalArgumentException("subItemTypes.size must >=1");
        }
    }

    boolean wrapperByStruct = false;

    public ListItemType wrapperByStruct() {
        wrapperByStruct = true;
        return this;
    }

    protected ListItemType(String name, ItemType subItemType) {
        super(name);//super("STRING");
        this.subItemType = subItemType;//this.itemTypes = ItemTypeGroup;
    }

    /**
     * @param headSize headSize
     * @return this
     */
    public ListItemType headSize(int headSize) {
        this.headSize = headSize;
        return this;
    }

    protected List<Item> _newValue() {
        return new ArrayList<>();
    }

    /**
     * @return result
     */
    @Override
    public Item create() {
        return _newItem(_newValue());//return new ListItem(this, new ArrayList());//return new ListItem(this, INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {//待测试。
        int size = in.nextInt();
        List<Item> groups = _newValue();//new ArrayList();
        for (int i = 0; i < size; i++) {
            groups.add(subItemType.load(in));
        }
        return _newItem(groups);
    }

    /**
     * @param in in
     * @return this
     */
    @Override
    public Item load(BytesLoader in) {
        int len = in.loadInt(headSize);//in.loadUnsignedByte();
        List<Item> groups = _newValue();//new ArrayList();
        for (int i = 0; i < len; i++) {
            groups.add(subItemType.load(in));
        }
        return _newItem(groups);
    }

    @Override
    public Item load(Iterator<Object> in) {
        int len = ((Number) in.next()).intValue();
        List<Item> groups = _newValue();//new ArrayList();
        for (int i = 0; i < len; i++) {
            Item subItem = subItemType.load(in);
            groups.add(subItem);
        }
        return _newItem(groups);
    }

    public Item LoadOne(Iterator<Object> in) {
        return subItemType.load(in);
    }

    /**
     * @param itemValue itemValue
     * @param build     builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof List) {
//            List<List<Item>> groups = (List) itemValue;
//            int len = groups.size();
//            build.appendNumber(headSize, len);//build.addByte(len);
//            for (List<Item> itemsInGroup : groups) {
//                for (int i = 0; i < itemTypes.length; i++) {
//                    itemTypes[i].toBytes(itemsInGroup.get(i), build);
//                }
//            }
            List<Item> groups = (List) itemValue;
            int len = groups.size();
            build.addNum(headSize, len);//build.addByte(len);
            for (Item item : groups) {
                item.toBytes(build);//item.toBytes(item, build);
            }
        }
    }

    @Override
    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        List<Item> subitems = (List<Item>) itemValue;
        build.add(subitems.size());//len
        subitems.forEach((subitem) -> subitem.toFlatObject(build));
    }

    //    @Override
//    protected Object defaultValue() {
//        return INIT_VAL;
//    }
    @Override
    protected Class insideValueClass() {
        return List.class;
    }

    /**
     * @param itemValue itemValue
     * @return result
     */
    @Override
    public String toString(Object itemValue) {
        if (itemValue != null) {
            List<Item> items = (List) itemValue;
            return items.stream().map(String::valueOf)
                    .collect(Collectors.joining(",", "[", "]"));
        } else {
            return "null";
        }
    }

    @Override
    public int dbParamCount() {
        //return this.subItemType.dbParamCount();
        return 1;
    }

    /**
     * 每次访问，内部会自动移动List游标。
     *
     * @param item      item
     * @param statement statement
     * @param pos       位置
     * @return result
     * @throws SQLException 异常
     */
    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
//        ListItem listItem = (ListItem) item;
//        int index = listItem.databaseCurson;
//        List<Item> items = ((ArrayList<List<Item>>) listItem.getValue()).get(index);
//        int cnt = 0;
//        statement.setInt(pos + cnt++, index);
//        for (Item itemInGroup : items) {
//            cnt += itemInGroup.statementParam(statement, pos);
//        }
//        listItem.databaseCurson++;
//        return cnt;
        statement.setString(pos++, item.formatFlatObjects());
        return 1;
    }

    @Override
    public List<? extends ItemType> flatItemTypes() {
        //return this.subItemType.flatItemTypes();
        return Collections.singletonList(CSTR);
    }

    @Override
    protected List<Item> itemValue(Item item) {//可以在此转型到具体类型。也可以在此统一合法性监测。
        return (List<Item>) item.getValue();
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        List<Item> list = itemValue(item);
        Item subItem = list.get(key);
        return subItem;
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        Item newItem = subItemType().create().setValue(subitemValue);
        ((List) item.getValue()).add(newItem);
    }

//    public class ListItem extends Item {
//
//        private int databaseCurson = 0;
//
//        public int getDatabaseCurson() {
//            return databaseCurson;
//        }
//
//        public ListItem(ListItemType itemType, List value) {
//            super(itemType, value);
//        }
//
//        public int size() {
//            return ((List) this.getValue()).size();
//        }
//        
//        public List<Item> list(){
//            return (List<Item>)super.getValue();
//        }
//        
//        public int dbCurson() {
//            return databaseCurson;
//        }
//        
//        public ListItem addItem(Item item) {
//            if (wrapperByStruct) {
//                if (item.itemType() instanceof ItemTypeStructOfList) {
//                    list().add(item);
//                    return this;
//                }
//            } else {
//                if (subItemType.getClass().isInstance(item.itemType())) {
//                    list().add(item);
//                    return this;
//                }
//            }
//            throw new IllegalArgumentException();
//        }
//
//        public ListItem add(Iterator<Object> in) {
//            ListItemType listType = (ListItemType)this.itemType();
//            Item subItem = listType.LoadOne(in);
//            addItem(subItem);
//            return this;
//        }
//
//    }
}
