/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.function.Function;

/**
 * @param <T> T
 * @author gongler
 */
public abstract class ItemType<T extends ItemType> {

    private static final long serialVersionUID = 1L;

    public static NumberItemType 包类型(int cmdType, String name) {
        NumberItemType type = HEX(1, name).defaultVal(cmdType);//new NumberItemType(1, name).defaultVal(cmdType);//"包类型"
        return type;
    }

    public static NumberItemType NUM(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name);
        return type;
    }

    public static NumberItemType DEC(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name).显示进制(10);
        return type;
    }

    public static NumberItemType HEX(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name).显示进制(16);
        return type;
    }

    public static NumberItemType BIN(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name).显示进制(2);
        return type;
    }

    public static NumberItemType BITS(int bitCnt, String name) {//wanghgadd 2021年11月3日09:32:04 以若干bit的项
        NumberItemType type = new NumberItemType(0, bitCnt, name);
        return type;
    }

    public static final ItemType CSTR = new StringItemType("CSTR").description("'\0'以结尾的字符串项"); //对名称无要求时，可以用这个

    public static StringWithLengthItemType STR(int byteCount, String name) {
        StringWithLengthItemType type = byteCount > 0 ? StringWithLengthItemType.withFixLength(byteCount, name) : StringWithLengthItemType.withLengthHeader(byteCount, name);
        return type;
    }

    /**
     * 有符号（可能出现负数）数
     *
     * @param byteCnt 字节数
     * @param name    item type name
     * @return instance
     */
    public static FlagSignedNumberItemType SNUM(int byteCnt, String name) {
        FlagSignedNumberItemType type = new FlagSignedNumberItemType(byteCnt, name);
        return type;
    }

    /**
     * 字节块
     *
     * @param bytes byte count
     * @param name  name
     * @return itemType
     */
    public static ItemType BYTES(int bytes, String name) {
        return new BytesItemType(bytes, name);
    }

    /**
     * 剩余字节块
     *
     * @param name name
     * @return itemType
     */
    public static ItemType REMAIN_BYTES(String name) {
        return new BytesItemType(0, name);
    }

//    /**
//     * '\0'结尾的变长字符串
//     *
//     * @param name
//     * @return
//     */
//    public static ItemType STRING(String name) {
//        return new StringItemType(name);
//    }

//    /**
//     *
//     *
//     * @param name
//     * @return
//     */
//    public static ItemType STRING_WITH_HEAD(String name) {
//        int headerBytes = 1;
//        return StringWithLengthItemType.withLengthHeader(headerBytes, name);
//    }

    /**
     * 定长字符串
     *
     * @param bytes byte count
     * @param name  name
     * @return itemType
     */
    public static ItemType BYTES_ASC(int bytes, String name) {
        return StringWithLengthItemType.withFixLength(bytes, name);
    }

    /**
     * 列表（头部的1字节）
     *
     * @param name          name
     * @param ItemTypeGroup subitemTypes
     * @return itemType
     */
    public static ItemType LIST(String name, ItemType... ItemTypeGroup) {
        return ListItemType.of(name, ItemTypeGroup);
    }

    /**
     * 含4字节头部的列表
     *
     * @param name          name
     * @param ItemTypeGroup subitemTypes
     * @return itemType
     */
    public static ItemType LIST_H4(String name, ItemType... ItemTypeGroup) {
        return ListItemType.of(name, ItemTypeGroup).headSize(4);
    }

    public static ItemType STRUCT(String name, ItemType... ItemTypeGroup) {
        return new ItemTypeStruct(name, ItemTypeGroup);
    }

    /**
     * 限制：8字节以内
     *
     * @param bytes byte count
     * @param name  name
     * @return NumberItemType
     */
    public static NumberItemType BCD(int bytes, String name) {
        return NumberItemType.BCD(bytes, name);//return new BcdItemTypeAsString(bytes, name);//20150602 ICCID数值过大，内部不宜用Long表示。new BcdItemType(bytes, name);
    }

    /**
     * BCD6字节，含日期和时间：年月日时分秒
     *
     * @param name name
     * @return itemType
     */
    public static ItemType BCD_DATETIME(String name) {
        return DatetimeBcdItemType.YYMMDDHHMMSS(name);//new BcdItemType(6, name).defaultValue(0x2015_03_27_22_32_00L);
    }

    /**
     * BCD3字节，只有日期：年月日
     *
     * @param name name
     * @return itemType
     */
    public static ItemType BCD_DATE(String name) {
        return DatetimeBcdItemType.YYMMDD(name);//new BcdItemType(3, name).defaultValue(0x2015_03_27L);
    }

    /**
     *
     */
    private final String name;

    private String description = "";

    protected ItemType(String name) {
        this.name = name;
    }

    public String name() {
        return name;
    }

    /**
     * 为来可提取的注释信息。
     *
     * @param describe 描述
     * @return this
     */
    public T description(String describe) {
        this.description = describe;
        return (T) this;
    }

    public String description() {
        return description;
    }

    /**
     * @param item item
     * @return bool
     */
    public boolean match(Item item) {
        return item != null && this.equals(item.itemType());
    }

    /**
     * @param in loader
     * @return item
     */
    public abstract Item load(BytesLoader in);

    /**
     * 允许从字符串载入数据(为数据库载入准备)
     *
     * @param in scanner
     * @return item
     */
    public abstract Item load(Scanner in);

    public Item load(Iterator<Object> in) {//20150514add
        return this.create().setValue(in.next());//默认单值实现。
    }

//    public Item load(Object... objects) {//20150514add
//        return load(new IteratorBuilder().add(objects).iterator());
//    }

    public Item load(Object first, Object... objects) {//wanghgmodified 2021年11月2日13:41:14 避免错误
        return load(new IteratorBuilder().add(first).add(objects).iterator());
    }

    /**
     * @param itemValue itemValue
     * @param build     builder
     */
    public abstract void toBytes(Object itemValue, BytesBuilder build);

    public final void toBytes(Item item, BytesBuilder build) {
        toBytes(item.getValue(), build);
    }

    /**
     * @param item item
     * @return string
     */
    public String toString(Item item) {
        if (match(item)) {
            return toString(item.getValue());
        } else {
            return "null";
        }
    }

    /**
     * @param itemValue itemValue
     * @return string
     */
    public String toString(Object itemValue) {
        if (itemValue != null) {
            return String.valueOf(itemValue);
        } else {
            return "null";
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "_" + name;

    }

    /**
     * @return item
     */
    public abstract Item create();

    /**
     * 判断是否与内部保存类型完全一致。
     *
     * @param value value
     * @return bool
     */
    private boolean matchInsideValueType(Object value) {
        return value != null && insideValueClass().isInstance(value); //defaultValue().getClass();
    }

    //protected abstract Object defaultValue();
    protected abstract Class insideValueClass();

    //    boolean isDoubleType() {
//        return false;
//    }
//
    public int dbParamCount() {
        return 1;//默认类型是1个，但列表时是多个。
    }

    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setObject(pos, item.getValue());//默认实现
        return 1;
    }

    public final String formatFlatObjects(Item item) {
        IteratorBuilder<Object> build = new IteratorBuilder<>();
        item.toFlatObject(build);
        return build.toString("|");
    }

    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        build.add(itemValue);//默认实现。输出多值时，需要重写。例如：Struct、List、Map
    }

    protected void safeSetItemValue(Item item, Object value) {
        if (matchInsideValueType(value)) {
            item.unsafeSetValue(value);//.value = value;//不要再item.setValue(value);
        } else {
            throw new IllegalArgumentException("赋值类型错误：" + item.itemType().toString() + "<-" + value);
        }
    }

    static <T> T apply(T obj, Function<T, T> func) {
        return func.apply(obj);
    }

    protected final Item _newItem(Object newItemValue) {
        Item instance = new Item(this, newItemValue);
        return instance;
    }

    public List<? extends ItemType> flatItemTypes() {//默认实现，给数据库传多参数时，需要覆盖本方法
        return Collections.singletonList(this);
    }

    public double toDoubleImpl(Item item) {
        throw new UnsupportedOperationException();//默认实现，经纬度浮点小数专用。
    }

    protected Object itemValue(Item item) {//可以在此转型到具体类型。也可以在此统一合法性监测。
        return item.getValue();
    }

    protected final void setSubitemImpl(Item item, int key, Object newValue) {
        getSubitemImpl(item, key).setValue(newValue);
    }

    protected abstract Item getSubitemImpl(Item item, int key);//wanghg20190531add

    protected abstract void addSubitemImpl(Item item, Object subitemValue);//wanghg20190531add
//    protected Item getSubitemImpl(Item item, int key) {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    protected void addSubitemImpl(Item item, Object subitemValue) {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }

}
