/*
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.Bytesable;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * @author gongler
 */
public class Item implements Bytesable {

    private static final long serialVersionUID = 1L;

    private final ItemType refType;
    private Object value;

    /**
     * @param itemType itemType
     * @param value    value
     */
    public Item(ItemType itemType, Object value) {
        this.refType = itemType;
        this.value = value;
    }

    public ItemType itemType() {
        return refType;
    }

    /**
     * @return value
     */
    public Object getValue() {
        return value;
    }

    /**
     * @param value new value
     * @return item
     */
    public Item setValue(Object value) {
        if (value == null) {//如果是空值，则取用默认值。
            value = refType.create().getValue();
        } else {
            if (value instanceof Item) {
                throw new IllegalArgumentException("Item.Value MUST be not Item.");
            }
        }
        refType.safeSetItemValue(this, value);//this.value = value;
        return this;
    }

    public void unsafeSetValue(Object value) {
        this.value = value;
    }

    /**
     * @return longvalue
     */
    public long longValue() {
        if (value instanceof Number) {
            return ((Number) value).longValue();
        } else {
            return 0L;
        }
    }

    public double doubleValue() {
        return (double) longValue();
    }

    /**
     * @return int
     */
    public int intValue() {
        if (value instanceof Number) {
            return ((Number) value).intValue();
        } else {
            return 0;
        }
    }

    /**
     * @return stringValue
     */
    public String stringValue() {
        if (value instanceof String) {
            return (String) value;
        } else {
            return "";
        }
    }

    /**
     * @return datetime value
     */
    public LocalDateTime datetimeValue() {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime) value;
        } else {
            return DatetimeBcdItemType.INIT_VAL;
        }
    }

    /**
     * @param key key
     * @return item
     */
    public final Item getSubitem(int key) {
        return refType.getSubitemImpl(this, key);
    }

    public final Item setSubitem(int key, Object newValue) {
        refType.setSubitemImpl(this, key, newValue);
        return this;
    }

    public final Item addSubitem(Item subitem) {
        return addSubitem(subitem.getValue());
    }

    public final Item addSubitem(Object subitemValue) {
        refType.addSubitemImpl(this, subitemValue);
        return this;
    }

    /**
     * @return byte[]
     */
    public byte[] bytesValue() {
        if (value instanceof byte[]) {
            return (byte[]) value;
        } else {
            return new byte[0];
        }
    }

//    /**
//     * @return
//     */
//    @Deprecated//@Override
//    public byte[] toBytes() {
//        return new BytesBuilder().add(this).toBytes();
//    }

    /**
     * @param out builder
     */
    @Override
    public void toBytes(BytesBuilder out) {
        refType.toBytes(value, out);
    }

    public void toFlatObject(IteratorBuilder<Object> build) {
        refType.toFlatObject(this, build);//debug build.add(this);//默认实现
    }

    public final String formatFlatObjects() {//为了方便合并成一个方便解析的字符串
        return this.itemType().formatFlatObjects(this);//委托给类型
    }

    @Override
    public String toString() {
        //        buf.append(this.getClass().getSimpleName()).append(":").append(this.getValue()).append(":").append(getValue() != null ? getValue().getClass().toString()
//                : "").append(":");
        return refType.toString(this.getValue());
    }

    //    boolean isDouble() {
//        return this.refType.isDoubleType();
//    }
    public int statementParam(CallableStatement statement, int pos) throws SQLException {
        return this.refType.statementParamImpl(this, statement, pos);
    }

    public Timestamp toTimestamp() {
        return Timestamp.valueOf((LocalDateTime) this.getValue());
    }

    /**
     * 数字操作：从内部定点小数转成浮点小数。
     *
     * @return double value
     */
    public double toDouble() {
        return refType.toDoubleImpl(this);//throw new UnsupportedOperationException();//默认实现，经纬度浮点小数专用。
    }

    public Map<Long, Item> mapValue() {
        return (Map<Long, Item>) getValue();//throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
