/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Scanner;

/**
 * BCD类型
 *
 * @author gongler
 */
public class DatetimeBcdItemType extends ItemType<BytesItemType> {

    private static final long serialVersionUID = 1L;

    public static final LocalDateTime INIT_VAL = LocalDateTime.of(2000, 1, 1, 1, 1, 1);

    public static DatetimeBcdItemType YYMMDDHHMMSS(String name) {
        return new DatetimeBcdItemType(name, DatetimeBcdType.YYMMDDHHMMSS);
    }

    public static DatetimeBcdItemType YYMMDD(String name) {
        return new DatetimeBcdItemType(name, DatetimeBcdType.YYMMDD);
    }

    final DatetimeBcdType datetimieBcdType;

    public DatetimeBcdItemType(String name) {
        this(name, DatetimeBcdType.YYMMDDHHMMSS);
    }

    public DatetimeBcdItemType(String name, DatetimeBcdType datetimieBcdType) {
        super(name);
        this.datetimieBcdType = datetimieBcdType;
    }

//    @Override
//    protected LocalDateTime defaultValue() {
//        return INIT_VAL;
//    }

    @Override
    protected Class insideValueClass() {
        return LocalDateTime.class;
    }

    /**
     * @return item
     */
    @Override
    public Item create() {
        LocalDateTime datetime = LocalDateTime.now();
        return _newItem(datetime);
    }

    /**
     * @param in such as "2007-12-03T10:15:30" or "2007-12-03T10:15"
     * @return item
     */
    @Override
    public Item load(Scanner in) {
        LocalDateTime datetime = GonglerUtil.LocalDateTime2000_01_01;//
        try {
            String value = in.next();
            datetime = LocalDateTime.parse(value);//such as "2007-12-03T10:15:30" or "2007-12-03T10:15"
        } catch (Exception e) {
        }
        return _newItem(datetime);
    }

    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        int year = 0, month = 0, day = 0, hour = 0, minute = 0, second = 0;
        if (datetimieBcdType.hasDate) {
            year = 2000 + (int) in.loadBcdInt(1);
            month = (int) in.loadBcdInt(1);
            day = (int) in.loadBcdInt(1);
        }
        if (datetimieBcdType.hasTime) {
            hour = (int) in.loadBcdInt(1);
            minute = (int) in.loadBcdInt(1);
            second = (int) in.loadBcdInt(1);
        }

        LocalDateTime datetime = LocalDateTime.of(year, month, day, hour, minute, second);

        return _newItem(datetime);

    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setTimestamp(pos++, item.toTimestamp());//经纬度//statement.setTimestamp(pos++, Timestamp.valueOf((LocalDateTime) itemValue));//经纬度
        return 1;
    }

    /**
     * @param itemValue itemValue
     * @param out       builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        LocalDateTime datetime = (LocalDateTime) itemValue;
        if (datetimieBcdType.hasDate) {
            out.addBcd(1, datetime.getYear() % 100);
            out.addBcd(1, datetime.getMonthValue());
            out.addBcd(1, datetime.getDayOfMonth());
        }
        if (datetimieBcdType.hasTime) {
            out.addBcd(1, datetime.getHour());
            out.addBcd(1, datetime.getMinute());
            out.addBcd(1, datetime.getSecond());
        }
    }

    private static final DateTimeFormatter YYYYMMDD_HHMMSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * @param itemValue itemValue
     * @return string
     */
    @Override
    public String toString(Object itemValue) {
        if (itemValue instanceof LocalDateTime) {
            LocalDateTime datetime = (LocalDateTime) itemValue;
            return YYYYMMDD_HHMMSS.format(datetime);//String.valueOf(itemValue);//ISO-8601 formats:
        } else {
            throw new IllegalArgumentException("参数类型错误" + itemValue);
        }
    }

    public enum DatetimeBcdType {

        YYMMDDHHMMSS(6, true, true),
        YYMMDD(3, true, false),
        HHMMSS(3, false, true);

        int len;
        private final boolean hasDate;
        private final boolean hasTime;

        DatetimeBcdType(int len, boolean date, boolean time) {
            this.len = len;
            this.hasDate = date;
            this.hasTime = time;
        }

        public int len() {
            return len;
        }
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
////        System.out.println("test ");
////        DatetimeBcdItemType type = new DatetimeBcdItemType("name");
////        System.out.println("" + type.create());
////        BytesBuilder build = new BytesBuilder();
////        type.toBytes(LocalDateTime.now(), build);
////        System.out.println("" + build);
//        //LocalDateTime.parse(value);
//        System.out.println("" + LocalDateTime.parse("2014-02-13T12:13").format(YYYYMMDD_HHMMSS));
//        System.out.println("" + LocalDateTime.parse("2014-02-13T12:13:14"));
//        System.out.println("" + LocalDateTime.parse("2014-12-13T12:13"));
//        //System.out.println(""+LocalDateTime.parse("2014-12-13T12"));
//    }

}
