/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

/**
 * 补码有符号数值
 *
 * @author gongler
 * 2021年11月2日
 */
public class ComplementSignedNumberItemType extends NumberItemType {//extends NumberItemType<SignedNumberItemType> {

    private static final long serialVersionUID = 1L;

    final long flagMask;
    final long valMask;//0111111  //1000001表示-1时使用

    final long valAllMask;//111111  //wanghgadd 补码使用

    public ComplementSignedNumberItemType(int bytes, String name) {
        this(bytes, 0, name);
    }

    public ComplementSignedNumberItemType(int bytes, int bits, String name) {
        super(bytes, bits, name);
        if (bits() == 0) {
            flagMask = (1 << (bytes() * 8 - 1));
            long valM = 0;
            for (int i = 0; i < bytes; i++) {
                valM <<= 8;
                valM |= 0xFF;
            }
            this.valAllMask = valM;
            valM ^= flagMask;
            valMask = valM;//wanghg补注：根据代码阅读：这里生成除了除了最高位是0外都置为1 4字节时， 7FFFFFFF
            //System.out.println("valMask:" + Long.toBinaryString(valMask));
            //System.out.println("flagMask" + Long.toBinaryString(flagMask));

        } else {
            flagMask = (1 << (allBits() - 1));
            long valM = 0;
            for (int i = 0; i < allBits(); i++) {
                valM <<= 1;
                valM |= 0x01;
            }
            this.valAllMask = valM;
            valM ^= flagMask;
            valMask = valM;
            //System.out.println("valMask:" + Long.toBinaryString(valMask));
            //System.out.println("flagMask" + Long.toBinaryString(flagMask));

        }
    }

    private long decodeValue(long val) {
        val = val & this.valAllMask;
        boolean minus = (val & flagMask) != 0;
        if (minus) {
            return -((val ^ this.valAllMask) + 1);
        } else {
            return val & this.valAllMask;
        }
    }

    private long encodeValue(long val) {
        return val;
    }

    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        Item item = super.load(in);
        item.setValue(decodeValue(item.longValue()));//从P808约定格式转成计算机格式
        return item;
    }

    /**
     * @param itemValue itemValue
     * @param out       builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = encodeValue(objectToLong(itemValue));
        //System.out.println(itemValue+"->"+val);
        super.toBytes(val, out);
    }

//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
////        for (int i = 1; i < 8; i++) {
////            System.out.println("test i" + i);
////            SignedNumberItemType type = new SignedNumberItemType(i, "name" + String.valueOf(i));
////            BytesBuilder build = new BytesBuilder();
////            type.toBytes(-1, build);
////            System.out.println("" + build);
////        }
//
//        Long val = -3L;
//        BytesBuilder build = new BytesBuilder();
//        TiamaesItemTypes.天迈纬度.toBytes(val, build);
//        TiamaesItemTypes.天迈经度.toBytes(1234, build);
//        build.commitBits();
//        build.commitBits();
//        byte[] buf = build.toBytes();
//        System.out.println(Util.BytesToHexString(buf));
//        BytesLoader loader = new BytesLoader(buf);
//        Item weidu = TiamaesItemTypes.天迈纬度.load(loader);
//        System.out.println(weidu.getValue() + ", " + weidu.getValue().getClass());
//        Item jingdu = TiamaesItemTypes.天迈经度.load(loader);
//        System.out.println("" + weidu + ", " + jingdu);
////        8007AF500004D200000000000000
////                [-128, 7, -81, 80, 0, 4, -46, 0, 0, 0, 0, 0, 0, 0]
////        -31477, class java.lang.Long
////                -31.-477, 1.234
//    }
}
