/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Scanner;

import static cn.gongler.util.bytes.Bytes.EMPTY_BYTES;
import static cn.gongler.util.bytes.HexUtil.HexToBytes;

/**
 * 针对现有协议，只支持1字节长度的变长字节块。
 *
 * @author gongler
 */
public class BytesItemType extends ItemType<BytesItemType> {

    private static final long serialVersionUID = 1L;

    private final int bytes;
    private final static byte[] INIT_VAL = new byte[0];

    public BytesItemType(int bytes, String name) {
        super(name);//super("BYTE[]");
        this.bytes = bytes;
    }

    /**
     * @return item
     */
    @Override
    public Item create() {
        return _newItem(this.bytes > 0 ? new byte[bytes] : INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
        byte[] bytes = EMPTY_BYTES;
        try {
            String value = in.next();
            bytes = HexToBytes(value);
        } catch (Exception e) {
        }
        return _newItem(bytes);
    }

    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        final byte[] buf;
        if (bytes == 0) {
            buf = in.loadRemainBytes();
        } else {
            final int len;
            if (bytes < 0) {
                len = in.loadUnsignedByte();
            } else {
                len = bytes;
            }

            buf = new byte[len];
            for (int i = 0; i < len; i++) {
                buf[i] = (byte) in.loadUnsignedByte();
            }
        }
        return _newItem(buf);
    }

    /**
     * @param itemValue itemValue
     * @param build     builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        byte[] bytesItem = (byte[]) itemValue;
        if (bytes < 0) {
            build.addByte(bytesItem.length);//len byte
        } else if (bytes > 0) {
            if (bytesItem.length != bytes) {
                bytesItem = Arrays.copyOf(bytesItem, bytes);
            }
        } else if (bytes == 0) {
            //原样输出
        }
        build.addBytes(bytesItem);
    }

    /**
     * @param itemValue itemValue
     * @return string
     */
    @Override
    public String toString(Object itemValue) {
        if (itemValue instanceof byte[]) {
            return BcdItemTypeAsString.Bytes2Hex((byte[]) itemValue);//Hex(((byte[]) itemValue));
        } else {
            return "null";
        }
    }

    //    @Override
//    protected Object defaultValue() {
//        return INIT_VAL;
//    }
    @Override
    protected Class insideValueClass() {
        return byte[].class;
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, toString(item.getValue()));
        return 1;
    }

//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
//        for (int i = 1; i < 8; i++) {
//            System.out.println("test i" + i);
//            BytesItemType type = new BytesItemType(i, "name" + i);
//            BytesBuilder build = new BytesBuilder();
//            type.toBytes(new byte[i], build);
//            System.out.println("" + build);
//        }
//
//    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
//7E0107004801234567890100030047313233343558352D494949000000000000000000000000000030303832303030898600211915760111750F535654372E3832302E3938332E3031095431353035323637350101A57E
