/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.util.Scanner;

/**
 * BCD类型 内部按Long保存，未启用
 *
 * @author gongler
 */
public class BcdItemTypeAsLong extends ItemType<BcdItemTypeAsLong> {

    private static final long serialVersionUID = 1L;

    protected final int bytes;
    private final Long INIT_VAL = 0L;

    public BcdItemTypeAsLong(int bytes, String name) {
        super(name);
        this.bytes = bytes;
    }

    /**
     * @return result
     */
    @Override
    public Item create() {
        return _newItem(INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
//wanghg20190628允许空值        long val = in.nextLong();
        long value = INIT_VAL;
        try {
            value = in.nextLong();
        } catch (Exception e) {
        }
        return _newItem(value);
    }

    /**
     * @param in in
     * @return result
     */
    @Override
    public Item load(BytesLoader in) {
        long value = in.loadBcd(bytes);
        return _newItem(value);
    }

    /**
     * @param itemValue itemValue
     * @param out       builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = (Long) itemValue;
        out.addBcd(bytes, val);
        //不需要再移动光标
    }

    /**
     * @param itemValue itemValue
     * @return string
     */
    @Override
    public String toString(Object itemValue) {
        if (itemValue instanceof Long) {
            return Long.toHexString((Long) itemValue);
        } else if (itemValue instanceof Number) {
            return toString(((Number) itemValue).longValue());
        } else {
            throw new IllegalArgumentException("参数类型错误" + itemValue);
        }
    }

//    @Override
//    protected Long defaultValue() {
//        return INIT_VAL;
//    }

    @Override
    protected Class insideValueClass() {
        return Long.class;
    }

//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
//        for (int i = 1; i < 8; i++) {
//            System.out.println("test i" + i);
//            BcdItemTypeAsLong type = new BcdItemTypeAsLong(i, "name" + i);
//            BytesBuilder build = new BytesBuilder();
//            type.toBytes(0x14233241L, build);
//            System.out.println("" + build);
//            System.out.println("" + type.toString(0x04030201L));
//        }
//
//    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
