package cn.gongler.util.math;

public class GonglerMath {

    private static final long serialVersionUID = 1L;

    int min(int... vals) {
        int min = Integer.MAX_VALUE;
        for (int v : vals) {
            int abs = Math.abs(v);
            if (abs < min) min = abs;
        }
        return min;
    }

    public static int 最大公约数(int big, int little) {
        if (big < little) {
            big ^= little;
            little ^= big;
            big ^= little;
        }
        int c = big % little;
        if (c == 0) {
            return little;
        } else {
            return 最大公约数(little, c);
        }
    }

    public static long 最大公约数(long big, long little) {
        if (big < little) {
            big ^= little;
            little ^= big;
            big ^= little;
        }
        long c = big % little;
        if (c == 0L) {
            return little;
        } else {
            return 最大公约数(little, c);
        }
    }


    public static int 最小公倍数(int a, int b) {
        return a * b / 最大公约数(a, b);
    }

    public static long 最小公倍数(long a, long b) {
        return a * b / 最大公约数(a, b);
    }


}
