/*
 *
 *
 *
 */
package cn.gongler.util.io;

import java.io.*;
import java.util.Timer;

import static cn.gongler.util.GonglerUtil.TimerTask;

/**
 * 实验性类
 *
 * @author gongler
 * @since 2016.08.29
 */
public class NoFlushOutputStream extends FilterOutputStream {

    private static final long serialVersionUID = 1L;


    public static void BufferedSystemOut() {
        System.setOut(BufferedPrintStream(System.out));
    }

    public static PrintStream BufferedPrintStream(PrintStream out) {
        return new PrintStream(new NoFlushOutputStream(out, 5));
    }

    public static PrintStream BufferedPrintStream(PrintStream out, int delaySecondsMax) {
        return new PrintStream(new NoFlushOutputStream(out, delaySecondsMax));
    }

    private static final Timer timer = new Timer(true);

    private NoFlushOutputStream(OutputStream out, int delaySecondsMax) {
        super(new MyBufferedOutputStream(out));
        Runtime.getRuntime().addShutdownHook(new Thread(this::forceFlush));
        timer.schedule(TimerTask(this::forceFlush), 1000 * delaySecondsMax, 1000 * delaySecondsMax);
    }

    private MyBufferedOutputStream out() {
        return (MyBufferedOutputStream) out;
    }

    private void forceFlush() {
        try {
            if (out().bufReadableCount() > 0) {
                out().flush();
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void flush() {
        //屏蔽刷新。
    }

    @Override
    public void close() throws IOException {
        forceFlush();
        out.close();
    }

    private static class MyBufferedOutputStream extends BufferedOutputStream {

        public MyBufferedOutputStream(OutputStream out) {
            super(out);
        }

        public int bufReadableCount() {
            return this.count;
        }

    }

//    public static void main(String[] args) throws FileNotFoundException, InterruptedException {
//
//        class MyLastOutputStream extends FilterOutputStream {
//
//            public MyLastOutputStream(OutputStream out) {
//                super(out);
//            }
//
//            @Override
//            public void write(byte b[], int off, int len) throws IOException {
//                super.write(b, off, len);
//                System.out.println("write();//" + Util.BytesToHex(b, off, len));
//            }
//
//            @Override
//            public void flush() throws IOException {
//                super.flush();
//                System.out.println("flush();");
//            }
//        }
//
//        //ResetSytemPrintStream();
//        System.setOut(new PrintStream(System.out, false));
//        Timer timer2 = new Timer();
//        timer2.schedule(Util.TimerTask(() -> {
//            System.out.println("" + LocalDateTime.now());
//        }), 1000L, 1000L);
//        timer2.schedule(Util.TimerTask(() -> {
//            System.out.println("" + LocalDateTime.now());
//        }), 1000L, 1000L * 5);
//
////        try (PrintStream out = new PrintStream(new NoFlushOutputStream(new MyLastOutputStream(new FileOutputStream("d:/test/a.txt"))));) {
////            timer2.schedule(Util.TimerTask(() -> {
////                System.out.println("" + LocalDateTime.now());
////                out.println("" + LocalDateTime.now());
////            }), 1000L, 1000L);
////            TimeUnit.SECONDS.sleep(33L);
////
////        }
//        System.out.println("exit");
//        TimeUnit.MINUTES.sleep(2L);
//    }
}
