/*
 */
package cn.gongler.util.io;

import java.io.*;

/**
 * @author gongler
 * @since 2019.06.27
 */
public class IoUtil {

    private static final long serialVersionUID = 1L;//Util

    private IoUtil() {
    }

    private static final int BUFFER_SIZE = 8192;

    public static long ReadAllBytes(InputStream source, OutputStream sink) throws IOException {
        if (!BufferedOutputStream.class.isInstance(sink)) {
            sink = new BufferedOutputStream(sink);
        }
        final byte[] buf = new byte[BUFFER_SIZE];
        long nread = 0L;
        int n;
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += n;
        }
        return nread;
    }

    public static byte[] ReadAllBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            if (!BufferedInputStream.class.isInstance(in)) {
                in = new BufferedInputStream(in);
            }
            ReadAllBytes(in, out);
            return out.toByteArray();
        }
    }

}
