/*
 */
package cn.gongler.util.io;

import java.io.*;

/**
 * 从文本文件中读取16进制文件。#为行注释开始标志。
 *
 * @author gongler
 * @since 2018.03.27
 */
public class HexInputStream extends InputStream {

    private static final long serialVersionUID = -1L;
    private final Reader reader;

    //    private int lastByte = 0;
//    private boolean hasLast = false;
    public HexInputStream(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public HexInputStream(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(new InputStreamReader(new FileInputStream(file), charset));
    }

    public HexInputStream(Reader reader) {
        this.reader = reader;
    }

    private static boolean isHexChar(int ch) {
        return (ch >= '0' && ch <= '9') || (ch >= 'a' && ch <= 'f') || (ch >= 'A' && ch <= 'F');
    }

    private static boolean reachLineEnd(int ch) {
        return ch == '\n' || ch == -1;
    }

    private void skitToLineEnd() throws IOException {
        while (!reachLineEnd(reader.read())) {
        }
    }

    private static int HexAscToVal(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - '0';
        } else if (ch >= 'A' && ch <= 'F') {
            return ch - 'A' + 10;
        } else if (ch >= 'a' && ch <= 'f') {
            return ch - 'a' + 10;
        } else {
            throw new IllegalArgumentException("参数不符合[0-9A-Fa-f]");//return ch;
        }
    }

    private int nextHalfByte() throws IOException {
        int byteVal;
        while ((byteVal = reader.read()) > 0) {
            if (Character.isWhitespace(byteVal)) {
                continue;
            } else if (byteVal == '#') {
                skitToLineEnd();
            } else if (isHexChar(byteVal)) {
                int halfByte = HexAscToVal((char) byteVal);
                return halfByte & 0x0F;
            } else {
                System.out.println("Exception: 非法符号：" + (char) byteVal + ",code=" + byteVal);//throw new IOException("非法符号："+(char)byteVal+",code="+byteVal);
            }
        }
        return byteVal;
    }

    @Override
    public int read() throws IOException {
        int hi = nextHalfByte();
        int lo = nextHalfByte();
        if (hi != -1 && lo == -1) {
            throw new IOException("文件结尾剩下半个字节：" + (char) hi + ",code=" + hi);
        }
        if (hi == -1 || lo == -1) {
            return -1;//文件结尾
        } else {
            return hi << 4 | lo;
        }
    }

    /**
     * 覆盖原来的read(buf, off, len),解决原来读入数组时，异常被捕捉，但不输出的不合理现象（Java BUG？）
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        for (; i < len; i++) {
            int c = read();
            if (c == -1) {
                break;
            }
            b[off + i] = (byte) c;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        if (reader != null) {
            reader.close();
        }
    }

//    public static void main(String[] args) throws FileNotFoundException, IOException {
//        Path a = new File("d:/test/hex.txt").toPath();
//        System.out.println(a.getName(0));
//        System.out.println(a.getName(1));
//        System.out.println(a.getFileName());
//        int byteVal = 0x32;
//        //System.out.println( "非法符号："+(char)byteVal+",code="+byteVal);
//        HexInputStream out = new HexInputStream(new File("d:/test/hex.txt"));
//        byte buf[] = new byte[1024];
//        int len = out.read(buf, 0, 1055);
//        System.out.println("" + Util.BytesToHex(buf));
//        out.close();
//    }

}
