package cn.gongler.util.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

/*
 *
 *
 *
 */

/**
 * @param <T> T
 * @param <U> U
 * @param <W> W
 * @author gongler
 */
@FunctionalInterface
public interface TriPredicate<T, U, W> {

    boolean test(T t, U u, W w);

    default TriPredicate<T, U, W> and(TriPredicate<? super T, ? super U, ? super W> other) {
        Objects.requireNonNull(other);
        return (T t, U u, W w) -> test(t, u, w) && other.test(t, u, w);
    }

    default TriPredicate<T, U, W> and(BiPredicate<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (T t, U u, W w) -> test(t, u, w) && other.test(t, u);
    }

    default TriPredicate<T, U, W> and(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return (T t, U u, W w) -> test(t, u, w) && other.test(t);
    }

    default TriPredicate<T, U, W> negate() {
        return (T t, U u, W w) -> !test(t, u, w);
    }

    default TriPredicate<T, U, W> or(TriPredicate<? super T, ? super U, ? super W> other) {
        Objects.requireNonNull(other);
        return (T t, U u, W w) -> test(t, u, w) || other.test(t, u, w);
    }

    default TriPredicate<T, U, W> or(BiPredicate<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (T t, U u, W w) -> test(t, u, w) || other.test(t, u);
    }

    default TriPredicate<T, U, W> or(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return (T t, U u, W w) -> test(t, u, w) || other.test(t);
    }
}
