/*
 *
 *
 *
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;

import java.util.Objects;
import java.util.function.Function;

/**
 * @param <T> T
 * @param <U> U
 * @param <W> W
 * @param <R> result
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionTriFunction<T, U, W, R> {

    R apply(T t, U u, W w) throws Exception;

    default <V> ExceptionTriFunction<T, U, W, V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (T t, U u, W w) -> after.apply(apply(t, u, w));
    }

    default R applyWithThrowAny(T t, U u, W w) {
        return GonglerUtil.CallWithThrowAny(() -> apply(t, u, w));
    }

    default R applyWithCatchAny(T t, U u, W w) {
        return applyWithCatchAny(t, u, w, null);
    }

    default R applyWithCatchAny(T t, U u, W w, R defaultVal) {
        return GonglerUtil.CallWithCatchAny(() -> this.apply(t, u, w), defaultVal);
    }

}
