/*
 *
 *
 *
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;

import java.util.Objects;

/**
 * @param <T> the first input argument
 * @param <U> the second input argument
 * @param <W> W
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionTriConsumer<T, U, W> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param t the first input argument
     * @param u the second input argument
     * @param w w
     * @throws java.lang.Exception Exception
     */
    void accept(T t, U u, W w) throws Exception;

    default ExceptionTriConsumer<T, U, W> acceptThen(T t, U u, W w) throws Exception {//20160913add
        accept(t, u, w);
        return this;
    }

    default TriConsumer<T, U, W> toTriConsumerWithCatchAny() {
        return (t, u, w) -> GonglerUtil.ExecuteWithCatchAny(() -> accept(t, u, w));
    }

    default void acceptWithCatchAny(T t, U u, W w) {
        GonglerUtil.ExecuteWithCatchAny(() -> accept(t, u, w));
    }

    default void acceptWithThrowAny(T t, U u, W w) {
        GonglerUtil.ExecuteWithThrowAny(() -> accept(t, u, w));
    }

    /**
     * Returns a composed {@code BiConsumer} that performs, in sequence, this
     * operation followed by the {@code after} operation. If performing either
     * operation throws an exception, it is relayed to the caller of the
     * composed operation. If performing this operation throws an exception, the
     * {@code after} operation will not be performed.
     *
     * @param after the operation to perform after this operation
     * @return a composed {@code BiConsumer} that performs in sequence this
     * operation followed by the {@code after} operation
     * @throws NullPointerException if {@code after} is null
     */
    default ExceptionTriConsumer<T, U, W> andThen(ExceptionTriConsumer<? super T, ? super U, ? super W> after) {
        Objects.requireNonNull(after);

        return (l, r, w) -> {
            accept(l, r, w);
            after.accept(l, r, w);
        };
    }
}
