/*
 *
 *
 *
 */
package cn.gongler.util.function;

import static cn.gongler.util.GonglerUtil.CallWithCatchAny;
import static cn.gongler.util.GonglerUtil.CallWithThrowAny;

/**
 * @param <T> T
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionSupplier<T> {

    /**
     * Gets a result.
     *
     * @return a result
     * @throws java.lang.Exception Exception
     */
    T get() throws Exception;

    default T getWithThrowAny() {
        return CallWithThrowAny(this::get);
    }

    default T getWithCatchAny() {
        return getWithCatchAny(null);
    }

    default T getWithCatchAny(T defaultVal) {
        return CallWithCatchAny(this::get, defaultVal);
    }

}
