/*
 *
 *
 *
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;

import java.util.function.IntFunction;

/**
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionIntFunction<R> {

    /**
     * Applies this function to the given argument.
     *
     * @param value the function argument
     * @return the function result
     * @throws java.lang.Exception Exception
     */
    R apply(int value) throws Exception;

    default IntFunction<R> toFunction() {
        return t -> GonglerUtil.CallWithThrowAny(() -> this.apply(t));
    }
}
