/*
 *
 *
 *
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;

import java.util.Objects;
import java.util.function.Consumer;

/**
 * @param <T> T
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionConsumer<T> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param t the first input argument
     * @throws java.lang.Exception 异常
     */
    void accept(T t) throws Exception;

    default ExceptionConsumer<T> acceptThen(T t) throws Exception {//20160913add
        accept(t);
        return this;
    }

    default void acceptWithCatchAny(T t) {
        GonglerUtil.ExecuteWithCatchAny(() -> accept(t));
    }

    default void acceptWithThrowAny(T t) {
        GonglerUtil.ExecuteWithThrowAny(() -> accept(t));
    }

    /**
     * Returns a composed {@code BiConsumer} that performs, in sequence, this
     * operation followed by the {@code after} operation. If performing either
     * operation throws an exception, it is relayed to the caller of the
     * composed operation. If performing this operation throws an exception, the
     * {@code after} operation will not be performed.
     *
     * @param after the operation to perform after this operation
     * @return a composed {@code BiConsumer} that performs in sequence this
     * operation followed by the {@code after} operation
     * @throws NullPointerException if {@code after} is null
     */
    default ExceptionConsumer<T> andThen(ExceptionConsumer<? super T> after) {
        Objects.requireNonNull(after);

        return (l) -> {
            accept(l);
            after.accept(l);
        };
    }

    default Consumer<T> toBiConsumer() {
        return t -> GonglerUtil.ExecuteWithThrowAny(() -> accept(t));
    }

}
