/*
 *
 *
 *
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;

import java.util.Objects;
import java.util.function.BiConsumer;

/**
 * @param <T> T
 * @param <U> U
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionBiConsumer<T, U> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param t the first input argument
     * @param u the second input argument
     * @throws java.lang.Exception 异常
     */
    void accept(T t, U u) throws Exception;

    default ExceptionBiConsumer<T, U> acceptThen(T t, U u) throws Exception {//20160913add
        accept(t, u);
        return this;
    }

    default void acceptWithCatchAny(T t, U u) {
        GonglerUtil.ExecuteWithCatchAny(() -> accept(t, u));
    }

    default void acceptWithThrowAny(T t, U u) {
        GonglerUtil.ExecuteWithThrowAny(() -> accept(t, u));
    }

    default ExceptionBiConsumer<T, U> andThen(ExceptionBiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);

        return (l, r) -> {
            accept(l, r);
            after.accept(l, r);
        };
    }

    default BiConsumer<T, U> toBiConsumer() {
        return (t, u) -> GonglerUtil.ExecuteWithThrowAny(() -> accept(t, u));
    }

}
