/*
 */
package cn.gongler.util.db.delegate;

import java.sql.*;

/**
 * @author gongler
 */
public class DelegateStatement implements Statement {

    private static final long serialVersionUID = 1L;

    private final Statement original;

    public DelegateStatement(Statement orginal) {
        this.original = orginal;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return original.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return original.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        original.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return original.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        original.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return original.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        original.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        original.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return original.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        original.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        original.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return original.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        original.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        original.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return original.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return original.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return original.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return original.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        original.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return original.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        original.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return original.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return original.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return original.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        original.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        original.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return original.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return original.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return original.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return original.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return original.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return original.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return original.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return original.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return original.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return original.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return original.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return original.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        original.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return original.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        original.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return original.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return original.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return original.isWrapperFor(iface);
    }

}
