/*
 *
 *
 *
 */
package cn.gongler.util.db;

import javax.sql.DataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

/**
 * @author gongler
 * @since 2016.08.01
 */
class DataSourceAdapter implements DataSource, ConnectionFactory {

    private static final long serialVersionUID = 2488330094927178570L;//DataSourceAdapter

    final ConnectionFactory connectionFactory;

    public static DataSource of(String url, String username, String password) {
        return new DataSourceAdapter(ConnectionFactory.of(url, url, password));
    }

    public static DataSource of(ConnectionFactory connectionFactory) {
        return new DataSourceAdapter(connectionFactory);
    }

    PrintWriter logWriter = new PrintWriter(System.out);
    private int timeoutSeconds;

    public DataSourceAdapter(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return connectionFactory.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T) this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

}
