/*
 *
 *
 *
 */
package cn.gongler.util.collection;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;

/**
 * 鉴于java.util.Stack设计过于难看。提供一个干净版
 *
 * @param <E> Element
 * @author gongler
 * @since 2016.09.28
 */
public interface IStack<E> extends Iterable<E> {

    E push(E item);

    E pop();

    E peek();

    int size();

    List<E> asList();

    static <E> IStack<E> of() {
        return of(new ConcurrentLinkedDeque());
    }

    static <E> IStack<E> of(Deque<E> from) {
        return new IStack<E>() {
            @Override
            public E pop() {
                return from.pop();
            }

            @Override
            public E push(E item) {
                from.push(item);
                return item;
            }

            @Override
            public E peek() {
                return from.peek();
            }

            @Override
            public int size() {
                return from.size();
            }

            @Override
            public List<E> asList() {
                return from.stream().collect(Collectors.toList());
            }

            @Override
            public Iterator<E> iterator() {
                return from.iterator();
            }

            @Override
            public String toString() {
                return "IStack@" + hashCode() + "_" + peek() + "_size" + size();
            }

        };
    }
}
