package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;

import java.nio.charset.Charset;
import java.util.Arrays;

import static cn.gongler.util.bytes.HexUtil.BytesToHex;
import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * @author honger
 * @date 2022/10/8
 */

class Str implements ToBytes {
    private static final long serialVersionUID = 1L;

    public static Str of(int byteCnt, CharSequence msg) {
        return utf8(byteCnt, msg);
    }

    public static Str of(int byteCnt, CharSequence msg, Charset charset) {
        return new Str(byteCnt, msg, charset);
    }

    public static Str gbk(int byteCnt, CharSequence msg) {
        return of(byteCnt, msg, Charset.forName("GBK"));
    }

    public static Str utf8(int byteCnt, CharSequence msg) {
        return of(byteCnt, msg, UTF_8);
    }

    private final int byteCnt;
    private final CharSequence msg;
    private final Charset charset;

    private Str(int byteCnt, CharSequence msg, Charset charset) {
        this.byteCnt = byteCnt;
        this.msg = msg;
        this.charset = charset;
    }

    private byte ch = '\0';

    /**
     * 允许
     *
     * @param ch 填充字符。默认是'\0'
     * @return this
     */
    public Str filledChar(char ch) {
        this.ch = (byte) ch;
        return this;
    }

    @Override
    public byte[] toBytes() {
        byte[] body = msg.toString().getBytes(charset);
        if (byteCnt > 0) {
            byte[] ret = Arrays.copyOf(body, byteCnt);
            if (body.length < byteCnt && ch != '\0') {//如果填充字符不是默认值，则必要时填充右侧
                Arrays.fill(ret, body.length, byteCnt, ch);
            }
            return ret;//Arrays.copyOf(body, byteCnt);//过长将截断,过短右补齐
//        } else if (byteCnt == Integer.MIN_VALUE) {//最小的负值作为长度0的不+'\0'的实验分支。有可能是过度设计，未来有可能删除，还待观察。
//            return BytesBuilder.of().addBytes(body).toBytes();
        } else if (byteCnt < 0) {
            GonglerUtil.requireLessThenOrEqual(Math.abs(byteCnt), 2);//不允许长度头超过2字节
            return BytesBuilder.of().addNum(-byteCnt, body.length).addBytes(body).toBytes();
        } else if (byteCnt == 0) {
            return BytesBuilder.of().addBytes(body).toBytes();//2022年10月25日 return BytesBuilder.of().addBytes(body).addByte(0).toBytes();
        } else {
            throw new IllegalArgumentException("" + byteCnt);
        }
    }

    public String toString() {
        return BytesToHex(toBytes());
    }
}
