/*
 * PROJECT: gonglerutils
 * DESCRIPTION:
 * USER: gongler
 * DATE: 2022-03-25
 */
package cn.gongler.util.bytes;

/**
 * 二进制位获取和设置工具类
 * 2022年3月25日23:59:53
 */
public class BitUtil {
    private static final long serialVersionUID = 1L;

    private BitUtil() {
    }

    public static boolean getBit(long value, int bitIndex) {
        return ((1L << bitIndex) & value) != 0;
    }

    public static long setBit(long value, int bitIndex, boolean bitVal) {
        return ((~(1L << bitIndex)) & value) | ((bitVal ? 1L : 0L) << bitIndex);
    }

    public static boolean getBit(int value, int bitIndex) {
        return ((1L << bitIndex) & value) != 0;
    }

    public static int setBit(int value, int bitIndex, boolean bitVal) {
        return ((~(1 << bitIndex)) & value) | ((bitVal ? 1 : 0) << bitIndex);
    }

    public static boolean getBit(short value, int bitIndex) {
        return ((1 << bitIndex) & value) != 0;
    }

    public static short setBit(short value, int bitIndex, boolean bitVal) {
        return (short) (((~(1 << bitIndex)) & value) | ((bitVal ? 1 : 0) << bitIndex));
    }

    public static boolean getBit(byte value, int bitIndex) {
        return ((1 << bitIndex) & value) != 0;
    }

    public static byte setBit(byte value, int bitIndex, boolean bitVal) {
        return (byte) (((~(1 << bitIndex)) & value) | ((bitVal ? 1 : 0) << bitIndex));
    }

    public static int getBits(long value, int bitIndex, int bitCnt) {
        return (int) ((value >>> bitIndex) & ((1 << bitCnt) - 1));
    }

    public static long setBits(long value, int bitIndex, int bitCnt, int bitVal) {
        long mask = (1L << bitCnt) - 1;
        return (value & (~mask)) | ((bitVal & mask) << bitIndex);
    }

    public static int setBits(int value, int bitIndex, int bitCnt, int bitsVal) {
        int mask = ((1 << bitCnt) - 1) << bitIndex;
        return (value & (~mask)) | ((bitsVal & mask) << bitIndex);
    }

    public static byte setBits(byte value, int bitIndex, int bitCnt, int bitsVal) {
        int mask = ((1 << bitCnt) - 1) << bitIndex;
        return (byte) ((value & (~mask)) | ((bitsVal & mask) << bitIndex));
    }

    public static short setBits(short value, int bitIndex, int bitCnt, int bitsVal) {
        int mask = ((1 << bitCnt) - 1) << bitIndex;
        return (short) ((value & (~mask)) | ((bitsVal & mask) << bitIndex));
    }

}
