/*
 *
 *
 *
 */
package cn.gongler.util;

import java.util.function.LongUnaryOperator;

/**
 * 根据绝对值，转换成增量。主要用来监控。
 *
 * @author gongler
 * @since 2016.08.01
 */
public class ToIncrement implements LongUnaryOperator {//20160729gongleradd

    private static final long serialVersionUID = 2853218721176918863L;//Increment
    long previousAbsoluteVal = 0;
    long initVal;

    public static ToIncrement of(long initVal) {
        return new ToIncrement(initVal);
    }

    public static ToIncrement of() {//20160928
        return new ToIncrement(0L);
    }

    private ToIncrement(long initVal) {
        this.initVal = initVal;
    }

    @Override
    public long applyAsLong(long absoluteVal) {
        long increment = absoluteVal - previousAbsoluteVal;
        this.previousAbsoluteVal = absoluteVal;
        return increment;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "_" + previousAbsoluteVal;
    }

}
