/*
 *
 *
 *
 */
package cn.gongler.util;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * 把待检查异常(Exception)包装成不检查异常(RuntimeException)
 *
 * @author gongler
 * @since 2016.08.19
 */
public class RuntimeExceptionFromException extends RuntimeException {

    private static final long serialVersionUID = -1614524519021823391L;//ExceptionToRuntimeException @since 2016-08-19

    public static RuntimeException of(Exception e) {
        return e instanceof RuntimeException ? (RuntimeException) e : new RuntimeExceptionFromException(e);
    }

    public static Exception toOriginal(RuntimeException e) {
        if (e instanceof RuntimeExceptionFromException) {
            return ((RuntimeExceptionFromException) e).getOriginal();
        }
        return e;
    }

    private final Exception original;

    private RuntimeExceptionFromException(Exception e) {
        super();
        this.original = e;
    }

    public Exception getOriginal() {
        return original;
    }

    @Override
    public String getMessage() {
        return original.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return original.getLocalizedMessage();
    }

    @Override
    public Throwable getCause() {
        return original.getCause();
    }

    @Override
    public Throwable initCause(Throwable cause) {
        original.initCause(cause);
        return this;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        original.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        original.printStackTrace(s);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return original.getStackTrace();
    }

    @Override
    public String toString() {
        return original.toString();
    }

}
