/*
 */
package cn.gongler.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author gongler
 * @since 2017.10.31.
 */
public class MinuteTimer implements AutoCloseable {

    private static final long serialVersionUID = 1L;


    public static MinuteTimer of() {
        return new MinuteTimer();
    }

    private final ScheduledExecutorService es;

    private final Set<ITask> tasks;

    private MinuteTimer() {
        es = Executors.newSingleThreadScheduledExecutor();
        tasks = new CopyOnWriteArraySet<>();//HashSet<>();
        es.scheduleAtFixedRate(() -> tasks.forEach(ITask::executeWithCatchAny), 1, 1, TimeUnit.MINUTES);
    }

    public MinuteTimer add(ITask task) {
        tasks.add(task);
        return this;
    }

    @Override
    public void close() throws Exception {
        es.shutdownNow();
    }

}
