/*
 *
 *
 *
 */
package cn.gongler.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.time.*;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

import static cn.gongler.util.GonglerUtil.*;
import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * 基于字符串的不同类型视图
 *
 * @author gongler
 * @since 2016.08.23
 */
public interface IProperties {

    static IProperties of(Function<String, String> mapper) {
        return mapper::apply;
    }

    static IProperties of(Map<String, String> map) {
        return map::get;
    }

    static IProperties of(URI uri) {//gongler20190327add
        String query = uri.getQuery();
        Map<String, String> map = new TreeMap<>();
        if (query != null) {
            Arrays.stream(query.split("&")).forEach(a -> {
                //System.out.println(""+a);
                String[] kv = a.split("=", 2);
                map.put(kv[0], kv[1]);
            });
        }
        return of(map);//map::get;
    }

    static IProperties of(Properties prop) {
        return prop::getProperty;
    }

    static IProperties of(Path propertiesFile) throws IOException {//gongler20171111
        try (Reader is = new InputStreamReader(new FileInputStream(propertiesFile.toFile()), UTF_8)) {//try (InputStream is = new FileInputStream(file.toFile());) {
            Properties prop = new Properties();
            prop.load(is);
            return of(prop);
        }
    }

    static IProperties of(Path propertiesFile, Consumer<Throwable> exceptionHandler) {//gongler20171111
        try {
            return of(propertiesFile);
        } catch (Throwable e) {
            exceptionHandler.accept(e);
            return of(new Properties());
        }
    }

//    public static IProperties of(Reader reader) throws IOException {//gongler20171111
//        Properties prop = new Properties();
//        prop.load(reader);
//        return of(prop);
//    }

    String getString(String key);

    default String getString(String key, String defaultVal) {
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? defaultVal : valStr;
    }

    default int getInt(String key) {
        return getInt(key, 0);
    }

    default int getInt(String key, int defaultVal) {
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? defaultVal : DecodeInt(valStr);
    }

    default Integer getInteger(String key) {
        return getInteger(key, null);
    }

    default Integer getInteger(String key, Integer defaultVal) {
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? defaultVal : DecodeInt(valStr);
    }

    default Long getLong(String key) {//gongler20190827update 基本类型改为基本类型的包装类
        return getLong(key, 0L);
    }

    default Long getLong(String key, Long defaultVal) {//gongler20190827update 基本类型改为基本类型的包装类
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? defaultVal : DecodeLong(valStr);
    }

    default Boolean getBoolean(String key) {//gongler20190827update 基本类型改为基本类型的包装类
        return getBoolean(key, false);
    }

    default Boolean getBoolean(String key, Boolean defaultVal) {//gongler20190827update 基本类型改为基本类型的包装类
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? defaultVal : Boolean.parseBoolean(valStr);
    }

    default Duration getDuration(String key) {//gongler20190827update 基本类型改为基本类型的包装类
        return getDuration(key, null);
    }//2022年5月25日

    default Duration getBoolean(String key, Duration defaultVal) {//2022年5月25日
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? defaultVal : Duration.parse(valStr);
    }

    default List<Long> getLongs(String key) {
        return DecodeLongs(getString(key));//prop.get(key));
    }

    default List<Integer> getIntegers(String key) {
        return DecodeIntegers(getString(key));//prop.get(key));
    }

    default <T> List<T> getObjects(String key, T defaultVal, Function<String, T> converter) {//gongler20190827add
        String valStr = getString(key);//prop.get(key);
        return IsEmptyString(valStr) ? Collections.emptyList() : Arrays.stream(valStr.split(",")).map(converter).collect(Collectors.toList());
    }

    /**
     * <pre>
     * Examples:
     *
     * "PT20.345S" -- parses as "20.345 seconds"
     * "PT15M"     -- parses as "15 minutes" (where a minute is 60 seconds)
     * "PT10H"     -- parses as "10 hours" (where an hour is 3600 seconds)
     * "P2D"       -- parses as "2 days" (where a day is 24 hours or 86400 seconds)
     * "P2DT3H4M"  -- parses as "2 days, 3 hours and 4 minutes"
     * "P-6H3M"    -- parses as "-6 hours and +3 minutes"
     * "-P6H3M"    -- parses as "-6 hours and -3 minutes"
     * "-P-6H+3M"  -- parses as "+6 hours and -3 minutes"
     * </pre>
     *
     * @param key        key
     * @param defaultVal 默认值
     * @return 返回值
     */
    default Duration getDuration(String key, Duration defaultVal) {
        String valStr = getString(key);
        return IsEmptyString(valStr) ? defaultVal : Duration.parse(valStr);
    }

    default LocalTime getLocalTime(String key, LocalTime defaultVal) {
        String valStr = getString(key);
        return IsEmptyString(valStr) ? defaultVal : LocalTime.parse(valStr);
    }

    default LocalDate getLocalDate(String key, LocalDate defaultVal) {
        String valStr = getString(key);
        return IsEmptyString(valStr) ? defaultVal : LocalDate.parse(valStr);
    }

    default LocalDateTime getLocalDateTime(String key) {//gongler20190827update 基本类型改为基本类型的包装类
        return getLocalDateTime(key, null);
    }

    /**
     * 2007-12-03T10:15:30
     *
     * @param key        key
     * @param defaultVal 默认值
     * @return 返回值
     */
    default LocalDateTime getLocalDateTime(String key, LocalDateTime defaultVal) {
        String valStr = getString(key);
        return IsEmptyString(valStr) ? defaultVal : LocalDateTime.parse(valStr);
    }

    /**
     * 2007-12-03T10:15:30+01:00
     *
     * @param key        key
     * @param defaultVal 默认值
     * @return 返回值
     */
    default OffsetDateTime getOffsetDateTime(String key, OffsetDateTime defaultVal) {
        String valStr = getString(key);
        return IsEmptyString(valStr) ? defaultVal : OffsetDateTime.parse(valStr);
    }

    default <T> T getObject(String key, T defaultVal, Function<String, T> func) {
        String valStr = getString(key);
        return IsEmptyString(valStr) ? defaultVal : func.apply(valStr);
    }

}
