/*
 *
 *
 *
 */
package cn.gongler.util;

import cn.gongler.util.tuple.Tuple;
import cn.gongler.util.tuple.Tuple2;
import cn.gongler.util.tuple.Tuple3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

/**
 * 比较用户名、密码、IP等信息，并返回错误码或信息。如果不需要返回错误码，比直接调用Comparater，可以指出差异项，并生成代码编号。
 * <pre>
 * 例：转发服务器验证用户登录并返回错误码的代码：
 * Tuple2&lt;Integer, Object&gt; result = EqualsComparatorWithErrorCode.of(LoginResponsePack.LOGIN_SUCESS)
 * .compare(loginPack.username(), xmlUser.username(), LoginResponsePack.LOGIN_USERNAME_MISTAKE)
 * .compare(loginPack.password(), xmlUser.password(), LoginResponsePack.LOGIN_PASSWORD_MISTAKE)
 * .compare(loginPack, xmlUser, (p, u) -&gt; u.ipcheck(p.remoteAddr().getAddress()), LoginResponsePack.LOGIN_IP_MISTAKE)
 * .result();
 * int errCode = result.first();
 * Object incorrectedVal = result.second();
 * LoginResponsePack ackPack = new LoginResponsePack(loginPack, errCode, incorrectedVal);
 *
 * </pre>
 *
 * @author gongler
 * @since 2016.08.04
 */
public class EqualsComparatorWithErrorCode<T> {

    private static final long serialVersionUID = 3395500877730237999L;//ComparaterWithErrorCode at 2016-08-04

    private final Tuple2<T, Object> defaultCode;
    List<Tuple3<Boolean, T, Object>> list = new ArrayList<>();

    public static <U> EqualsComparatorWithErrorCode<U> of(U defaultCode) {
        return new EqualsComparatorWithErrorCode<>(defaultCode);
    }

    public EqualsComparatorWithErrorCode(T defaultVal) {
        this.defaultCode = Tuple.of(defaultVal, null);
    }

    public EqualsComparatorWithErrorCode<T> compare(Object val, Object standardVal, T errCode) {
        return register(Objects.equals(val, standardVal), errCode, val);
    }

    public <L, R> EqualsComparatorWithErrorCode<T> compare(L val, R standardVal, BiFunction<L, R, Boolean> mapper, T errCode) {
        return register(mapper.apply(val, standardVal), errCode, val);
    }

    private EqualsComparatorWithErrorCode<T> register(Boolean b, T result, Object checkVal) {
        list.add(Tuple.of(b, result, checkVal));
        return this;
    }

    /**
     * @return T, incorrectVal
     */
    public Tuple2<T, Object> result() {
        for (Tuple3<Boolean, T, Object> tuple : list) {
            if (tuple.first() == false) {
                return Tuple.of(tuple.second(), tuple.third());
            }
        }
        return defaultCode;
    }
}
