package cn.gongler.util;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Function;

/**
 * @author honger
 * @since 3.1
 */
@FunctionalInterface
public interface EqualsComparator<T> {

    static <E, F> EqualsComparator<F> compare(Function<F, E> mapper) {
        Objects.requireNonNull(mapper);
        return (a, b) -> Objects.equals(mapper.apply(a), mapper.apply(b));
    }

    default <E> EqualsComparator<T> thenCompare(Function<T, E> mapper) {
        Objects.requireNonNull(mapper);
        return (a, b) -> apply(a, b) && Objects.equals(mapper.apply(a), mapper.apply(b));
    }

    boolean apply(T a, T b);


    static void main(String[] args) {
        LocalDateTime a = LocalDateTime.now();
        LocalDateTime b = a.minusMinutes(1);

        EqualsComparator<LocalDateTime> equalsComparator = EqualsComparator.compare(LocalDateTime::toLocalDate)
                .thenCompare(LocalDateTime::toLocalTime);
        System.out.println(equalsComparator.apply(a, a));
        System.out.println(equalsComparator.apply(a, b));
    }
}
