/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.text;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.text.StringLinker;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Function;

public class StringSpliter {
    private final String msg;
    private final String delimiter;
    private final int limit;
    private final String[] items;
    private int pos = 0;

    public static StringSpliter of(String msg) {
        return StringSpliter.of(msg, ",");
    }

    public static StringSpliter of(String msg, String delimiter) {
        return StringSpliter.of(msg, delimiter, 0);
    }

    public static StringSpliter of(String msg, String delimiter, int limit) {
        return new StringSpliter(msg, delimiter, limit);
    }

    public StringSpliter(String msg, String delimiter, int limit) {
        this.msg = GonglerUtil.WithDefault(msg, "");
        this.delimiter = delimiter;
        this.limit = limit;
        this.items = this.msg.split(delimiter, limit);
    }

    private String next() {
        String ret = this.get(this.pos);
        ++this.pos;
        return ret;
    }

    private String get(int index) {
        if (index >= this.items.length) {
            return null;
        }
        String item = this.items[index];
        if (item == null || "".equals(item)) {
            return null;
        }
        return item;
    }

    public int nextInt() {
        return this.nextInt(0);
    }

    public int nextInt(int defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return GonglerUtil.DecodeInt(next.trim());
    }

    public Integer nextInteger() {
        return this.nextInteger(null);
    }

    public Integer nextInteger(Integer defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return GonglerUtil.DecodeInt(next.trim());
    }

    public Long nextLong() {
        return this.nextLong(null);
    }

    public Long nextLong(Long defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return GonglerUtil.DecodeLong(next.trim());
    }

    public Double nextDouble() {
        return this.nextDouble(null);
    }

    public Double nextDouble(Double defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return Double.parseDouble(next.trim());
    }

    public Double getDouble(int index) {
        return this.getDouble(index, null);
    }

    public Double getDouble(int index, Double defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return Double.parseDouble(next.trim());
    }

    public String nextString() {
        return this.nextString(null);
    }

    public String nextString(String defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return next;
    }

    public <T> T nextObject(Function<String, T> decoder) {
        return this.nextObject(decoder, null);
    }

    public <T> T nextObject(Function<String, T> decoder, T defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return decoder.apply(next);
    }

    public int getInt(int index) {
        return this.getInt(index, 0);
    }

    public int getInt(int index, int defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return GonglerUtil.DecodeInt(next.trim());
    }

    public Integer getInteger(int index) {
        return this.getInteger(index, null);
    }

    public Integer getInteger(int index, Integer defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return GonglerUtil.DecodeInt(next.trim());
    }

    public Long getLong(int index) {
        return this.getLong(index, null);
    }

    public Long getLong(int index, Long defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return GonglerUtil.DecodeLong(next.trim());
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return next;
    }

    public Boolean nextBoolean() {
        return this.nextBoolean(null);
    }

    public Boolean nextBoolean(Boolean defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(next.trim());
    }

    public Boolean getBoolean(int index) {
        return this.getBoolean(index, null);
    }

    public Boolean getBoolean(int index, Boolean defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(next.trim());
    }

    public Duration nextDuration() {
        return this.nextDuration(null);
    }

    public Duration nextDuration(Duration defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return Duration.parse(next.trim());
    }

    public Duration getDuration(int index) {
        return this.getDuration(index, null);
    }

    public Duration getDuration(int index, Duration defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return Duration.parse(next.trim());
    }

    public LocalDateTime nextLocalDateTime() {
        return this.nextLocalDateTime(null);
    }

    public LocalDateTime nextLocalDateTime(LocalDateTime defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return LocalDateTime.parse(next.trim());
    }

    public LocalDateTime getLocalDateTime(int index) {
        return this.getLocalDateTime(index, null);
    }

    public LocalDateTime getLocalDateTime(int index, LocalDateTime defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return LocalDateTime.parse(next.trim());
    }

    public LocalDate nextLocalDate() {
        return this.nextLocalDate(null);
    }

    public LocalDate nextLocalDate(LocalDate defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return LocalDate.parse(next.trim());
    }

    public LocalDate getLocalDate(int index) {
        return this.getLocalDate(index, null);
    }

    public LocalDate getLocalDate(int index, LocalDate defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return LocalDate.parse(next.trim());
    }

    public LocalTime nextLocalTime() {
        return this.nextLocalTime(null);
    }

    public LocalTime nextLocalTime(LocalTime defaultVal) {
        String next = this.next();
        if (next == null) {
            return defaultVal;
        }
        return LocalTime.parse(next.trim());
    }

    public LocalTime getLocalTime(int index) {
        return this.getLocalTime(index, null);
    }

    public LocalTime getLocalTime(int index, LocalTime defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return LocalTime.parse(next.trim());
    }

    public <T> T getObject(int index, Function<String, T> decoder) {
        return this.getObject(index, decoder, null);
    }

    public <T> T getObject(int index, Function<String, T> decoder, T defaultVal) {
        String next = this.get(index);
        if (next == null) {
            return defaultVal;
        }
        return decoder.apply(next);
    }

    public StringSpliter nextAsSpliter(String delimiter) {
        return StringSpliter.of(this.nextString(), delimiter);
    }

    public StringSpliter nextAsSpliter(String delimiter, int limit) {
        return StringSpliter.of(this.nextString(), delimiter, limit);
    }

    public StringSpliter getAsSpliter(int index, String delimiter) {
        return this.getAsSpliter(index, delimiter, 0);
    }

    public StringSpliter getAsSpliter(int index, String delimiter, int limit) {
        return StringSpliter.of(this.get(index), delimiter, limit);
    }

    public String toString() {
        return StringLinker.of("{", ",", "}").add("[", this.msg, "]").add("pos:", this.pos).toString();
    }
}

