/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.LineUpDown;
import cn.gongler.util.sgeo.line.imp.LineBusstop;
import cn.gongler.util.sgeo.line.imp.LineSide;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;

public class Lowline {
    private static final long serialVersionUID = 8683820964875926888L;
    static final Lowline NULL = new Lowline(0L);
    long lowlineId;
    long refLineId = 0L;
    int lowlineSerial;
    final LineSide[] lineSides = new LineSide[]{new LineSide(LineUpDown.LINE_UP), new LineSide(LineUpDown.LINE_DOWN)};
    private String lowlineName = "lowlineName";

    public Lowline(long lowlineId) {
        this.lowlineId = lowlineId;
    }

    int getBusstopCnt(boolean upDown) {
        return this.lineSides[upDown ? 0 : 1].getBusstopCnt();
    }

    public long id() {
        return this.lowlineId;
    }

    int getLowLineSerial() {
        return this.lowlineSerial;
    }

    public LineSide getLineSide(LineUpDown upDown) {
        return this.lineSides[upDown.ordinal()];
    }

    public void appendBusstop(LineUpDown upDown, LineBusstop lineBusstop) {
        LineSide side = this.getLineSide(upDown);
        side.appendBusstop(lineBusstop);
        lineBusstop.setLineSide(side);
    }

    void clearBusstops() {
        for (LineSide lineSide : this.lineSides) {
            lineSide.clearBusstopList();
        }
    }

    void setParent(long lineId, int lineSubno) {
        this.refLineId = lineId;
        this.lowlineSerial = lineSubno;
    }

    void setName(String lowlineName) {
        this.lowlineName = lowlineName;
    }

    public LineSide getNextLineSide(LineSide lineSide) {
        LineUpDown reserve = LineUpDown.reverse(lineSide.upDown());
        LineSide nextLineSide = this.getLineSide(reserve);
        if (nextLineSide.getBusstopCnt() == 0) {
            nextLineSide = lineSide;
        }
        return nextLineSide;
    }

    public boolean existLineScope(Connection conn) throws SQLException {
        Scope geoScope = ScopeGroupFactory.of().scope(this.lowlineId);
        return geoScope != null;
    }

    public boolean inside(IGps gps, Connection conn) throws SQLException {
        return ScopeGroupFactory.of().inside(gps, this.lowlineId);
    }

    public String toString() {
        String builder = "\n " + this.getClass().getSimpleName() + "" + this.lowlineId + "," + this.lowlineName + "," + Arrays.toString(this.lineSides);
        return builder;
    }
}

