/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.line;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.db.DbUtil;
import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.BusFactory;
import cn.gongler.util.sgeo.gps.BusState;
import cn.gongler.util.sgeo.gps.IBusGpsListener;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.GpsIntervalDis;
import cn.gongler.util.sgeo.line.IAreaReachEventContext;
import cn.gongler.util.sgeo.line.IConnContext;
import cn.gongler.util.sgeo.line.IGpsDis;
import cn.gongler.util.sgeo.line.IGpsListener;
import cn.gongler.util.sgeo.line.ILeaveLineContext;
import cn.gongler.util.sgeo.line.ILineEventContext;
import cn.gongler.util.sgeo.line.ILineEventListener;
import cn.gongler.util.sgeo.line.IReachBusstopContext;
import cn.gongler.util.sgeo.line.ISwitchBusLineActions;
import cn.gongler.util.sgeo.line.LineUpDown;
import cn.gongler.util.sgeo.line.imp.BusstopState;
import cn.gongler.util.sgeo.line.imp.LineBusstop;
import cn.gongler.util.sgeo.line.imp.LineSide;
import cn.gongler.util.sgeo.line.imp.LowLineFactory;
import cn.gongler.util.sgeo.line.imp.Lowline;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;

@Deprecated
public class LineEventChecker
implements IBusGpsListener,
ISwitchBusLineActions {
    private static final long serialVersionUID = 1L;
    private Set<ILineEventListener> lineEventListenerSet = new HashSet<ILineEventListener>();
    private Set<IGpsListener> gpsListenerSet;
    DataSource ds;
    LowLineFactory lowlineFactory;
    private static String GPS_DIS_KEY = "GPS_DIS_KEY";
    private static String LAST_BUSSTOP_KEY = "LAST_BUSSTOP_KEY";
    private static String LAST_AREA_KEY = "LAST_AREA_KEY";

    public void addLineEventListener(ILineEventListener listener) {
        this.lineEventListenerSet.add(listener);
    }

    public void addGpsListener(IGpsListener listener) {
        this.gpsListenerSet.add(listener);
    }

    public LineEventChecker(Properties pro) {
        this.lineEventListenerSet.add(new SampleLineEventListener());
        this.gpsListenerSet = new HashSet<IGpsListener>();
        this.ds = null;
        this.lowlineFactory = null;
    }

    @Override
    public void config(Properties props) {
    }

    public void init(DataSource ds) throws SQLException {
        ScopeGroupFactory scopeFact = ScopeGroupFactory.of();
        scopeFact.connectionFactory(ds);
        this.ds = ds;
        this.lowlineFactory = new LowLineFactory(ds);
        this.lowlineFactory.load();
        this.loadBusState(ds.getConnection());
    }

    private Connection getConn() throws SQLException {
        if (this.ds == null) {
            return null;
        }
        return this.ds.getConnection();
    }

    public void close() {
        try {
            Connection conn = this.getConn();
            if (conn != null) {
                this.saveBusState(conn);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleBusGps(long busId, IGps gps, IConnContext gpsCxt) {
        Connection conn = null;
        try {
            int n;
            LineUpDown upDown;
            long driverId;
            long lowlineId;
            BusState bus;
            long packTime;
            block45: {
                if (this.ds == null) {
                    return;
                }
                conn = this.ds.getConnection();
                if (conn == null) {
                    return;
                }
                packTime = gps.gpsTime();
                InetSocketAddress addr = gpsCxt.getClientAddr();
                bus = BusFactory.getInstance().getBus(busId);
                lowlineId = bus.getLowlineId();
                driverId = bus.getDriverId();
                IGpsDis gpsDis = (IGpsDis)bus.getValue(GPS_DIS_KEY);
                if (gpsDis == null) {
                    gpsDis = new GpsIntervalDis();
                    bus.setValue(GPS_DIS_KEY, gpsDis);
                    System.out.println("getGpsDis0: " + busId + ", new GpsDis" + gpsDis);
                }
                gpsDis.pushGps(gps);
                bus.setValue("GPS_DIS", gpsDis.getDistance());
                upDown = bus.upDown();
                for (IGpsListener gpslist : this.gpsListenerSet) {
                    gpslist.handleBusGps(bus, gps, gpsCxt);
                }
                try {
                    AreaReachEventContext areaEventContxt = (AreaReachEventContext)bus.getValue(LAST_AREA_KEY);
                    if (areaEventContxt == null) {
                        Scope nextScopeInfo = ScopeGroupFactory.of().group(3L).firstInside(gps);
                        if (nextScopeInfo != null) {
                            long changId = nextScopeInfo.num1();
                            areaEventContxt = new AreaReachEventContext(nextScopeInfo, gps);
                            bus.setValue(LAST_AREA_KEY, areaEventContxt);
                            for (ILineEventListener iLineEventListener : this.lineEventListenerSet) {
                                iLineEventListener.reachArea(busId, gps, changId, areaEventContxt);
                            }
                        }
                        break block45;
                    }
                    Scope scopeInfo = areaEventContxt.getScopeInfo();
                    boolean inside = scopeInfo.inside(gps);
                    if (!inside) {
                        long changId = scopeInfo.num1();
                        for (ILineEventListener lis : this.lineEventListenerSet) {
                            lis.leaveArea(busId, gps, changId, areaEventContxt);
                        }
                        bus.setValue(LAST_AREA_KEY, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (lowlineId <= 0L) {
                return;
            }
            Lowline lowline = this.lowlineFactory.getLowLine(lowlineId);
            LineSide lineSide = lowline.getLineSide(upDown);
            BusstopState busstopState = (BusstopState)bus.getValue(LAST_BUSSTOP_KEY);
            if (busstopState == null) {
                busstopState = new BusstopState();
                bus.setValue(LAST_BUSSTOP_KEY, busstopState);
            }
            LineBusstop lastBusstop = busstopState.getBusstop();
            if (lowline.existLineScope(conn)) {
                IGps leaveLineFromGps = bus.getLeaveLineGps();
                boolean bl = lowline.inside(gps, conn);
                MyLineEventContext leaveLineEvent = new MyLineEventContext(lowline, lineSide, lastBusstop, driverId, gpsCxt);
                if (leaveLineFromGps == null) {
                    if (!bl) {
                        for (ILineEventListener iLineEventListener : this.lineEventListenerSet) {
                            iLineEventListener.leaveLine(packTime, busId, lowlineId, upDown, leaveLineEvent);
                        }
                        bus.setLeaveLineGps(gps);
                    }
                } else if (bl) {
                    int seconds = (int)(gps.gpsTime() - leaveLineFromGps.gpsTime()) / 1000;
                    for (ILineEventListener lis : this.lineEventListenerSet) {
                        lis.backLine(packTime, busId, lowlineId, upDown, seconds, leaveLineEvent);
                    }
                    bus.setLeaveLineGps(null);
                }
            }
            if (busstopState.isInBusstop()) {
                LineBusstop curBusstop = lastBusstop;
                if (curBusstop.inside(gps, conn)) return;
                long l = busstopState.getFromTime();
                int busstopSerial = lineSide.getBusstopSerial(curBusstop);
                long l2 = curBusstop.getBusstopId();
                int seconds = busstopState.leaveBusstop(curBusstop, gps);
                MyLineEventContext reachBusstopEvent = new MyLineEventContext(lowline, lineSide, curBusstop, driverId, gpsCxt);
                Iterator<ILineEventListener> iterator = this.lineEventListenerSet.iterator();
                while (iterator.hasNext()) {
                    ILineEventListener lis = iterator.next();
                    lis.leaveBusstop(packTime, busId, lowlineId, upDown, busstopSerial, l2, seconds, reachBusstopEvent);
                }
                return;
            }
            LineBusstop nextBusstop = lineSide.checkNextBusstop(gps, bus.getBusstopSerial(), conn);
            if (nextBusstop == null) return;
            if (nextBusstop == lastBusstop) return;
            System.out.println("reach " + nextBusstop + ", " + gps);
            busstopState.reachBusstop(nextBusstop, gps);
            int n2 = lineSide.getBusstopSerial(nextBusstop);
            long busstopId = nextBusstop.getBusstopId();
            int n3 = n = lastBusstop != null ? lastBusstop.getBusstopSerial() : -1;
            if (n2 < n) {
                LineSide newLineSide = lowline.getNextLineSide(lineSide);
                bus.switchLine(lowline.id(), newLineSide.upDown());
                bus.setValue(LAST_BUSSTOP_KEY, null);
                return;
            }
            if (n2 <= n) return;
            MyLineEventContext reachBusstopEvent = new MyLineEventContext(lowline, lineSide, nextBusstop, driverId, gpsCxt);
            for (ILineEventListener lis : this.lineEventListenerSet) {
                lis.reachBusstop(packTime, busId, lowlineId, upDown, n2, busstopId, reachBusstopEvent);
            }
            if (!lineSide.isFinalBusstop(n2)) return;
            LineUpDown newUp = lowline.getNextLineSide(lineSide).upDown();
            bus.switchLine(lowline.id(), newUp);
            bus.setValue(LAST_BUSSTOP_KEY, null);
            this.saveBusLine(conn, busId, lowlineId, newUp, gps.gpsTime());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void registed() {
    }

    @Override
    public void unregisted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchBusLine(long busId, long lowlineId, LineUpDown upDown) {
        BusState bus = BusFactory.getInstance().getBus(busId);
        LineSide lineSide = this.lowlineFactory.getLineSide(lowlineId, upDown);
        if (lineSide != null) {
            bus.switchLine(lowlineId, upDown);
            Connection conn = null;
            try {
                conn = this.ds.getConnection();
                this.saveBusLine(conn, busId, lowlineId, upDown, System.currentTimeMillis());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                GonglerUtil.Close(conn);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchBusDriverId(long busId, long driverId) {
        BusState bus = BusFactory.getInstance().getBus(busId);
        bus.setDriverId(driverId);
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            this.saveDriverId(conn, busId, driverId);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            GonglerUtil.Close(conn);
        }
        return true;
    }

    private void loadBusState(Connection connection) throws SQLException {
        DbUtil.ExecuteQuery(connection, "SELECT * FROM GPS_BUS_STATE ORDER BY BUS_NO", (rs, rowIndex) -> {
            long busId = rs.getLong("BUS_NO");
            long lowlineId = rs.getLong("LOWLINE_NO");
            int updown = rs.getInt("UPDOWN");
            long driverId = rs.getLong("DRIVER_NO");
            Timestamp datetime = rs.getTimestamp("UTIME");
            double distance = rs.getDouble("GPS_DIS");
            LineUpDown upDown = LineUpDown.parse(updown);
            BusState busState = BusFactory.getInstance().getBus(busId);
            busState.switchLine(lowlineId, upDown);
            busState.setDriverId(driverId);
        });
        for (BusState busState : BusFactory.getInstance().getIterator()) {
        }
    }

    private void saveBusLine(Connection conn, long busId, long lowlineId, LineUpDown upDown, long time) throws SQLException {
        int updown = upDown.ordinal();
        int cnt = DbUtil.ExecuteUpdate(conn, "update gps_bus_state set lowline_no=?, updown=?, utime=? where bus_no=? ", lowlineId, updown, new Timestamp(time), busId);
        if (cnt == 0) {
            DbUtil.ExecuteUpdate(conn, "insert into gps_bus_state(bus_no, lowline_no, updown, utime) values(?, ?, ?, ?) ", busId, lowlineId, updown, new Timestamp(time));
        }
        GonglerUtil.Commit(conn);
    }

    private void saveDriverId(Connection conn, long busId, long driverId) throws SQLException {
        int cnt = DbUtil.ExecuteUpdate(conn, "update gps_bus_state set driver_no=? where bus_no=? ", driverId, busId);
        GonglerUtil.Commit(conn);
    }

    private void saveBusState(Connection conn) throws SQLException {
        for (BusState bus : BusFactory.getInstance().getIterator()) {
            this.saveBusLine(conn, bus.getBusId(), bus.getLowlineId(), bus.upDown(), System.currentTimeMillis());
        }
    }

    private static class AreaReachEventContext
    implements IAreaReachEventContext {
        private static final long serialVersionUID = 1L;
        Scope scopeInfo;
        private final IGps reachGps;

        private AreaReachEventContext(Scope scopeInfo, IGps gps) {
            this.scopeInfo = scopeInfo;
            this.reachGps = gps;
        }

        @Override
        public Scope getScopeInfo() {
            return this.scopeInfo;
        }

        @Override
        public long getReachTime() {
            return this.reachGps.gpsTime();
        }
    }

    static class SampleLineEventListener
    implements ILineEventListener {
        private static final long serialVersionUID = 1L;

        SampleLineEventListener() {
        }

        @Override
        public void reachBusstop(long time, long busId, long lowlineId, LineUpDown upDown, int busstopSerial, long busstopId, IReachBusstopContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("reachBusstop: ").append(time).append(", ").append(busId).append(", ").append(lowlineId).append(", ").append((Object)upDown).append(", ").append(busstopSerial).append(", ").append(busstopId).append(", ").append(cxt);
        }

        @Override
        public void leaveBusstop(long time, long busId, long lowlineId, LineUpDown upDown, int busstopSerial, long busstopId, int seconds, IReachBusstopContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("leaveBusstop: ").append(time).append(", ").append(busId).append(", ").append(lowlineId).append(", ").append((Object)upDown).append(", ").append(busstopSerial).append(", ").append(busstopId).append(", ").append(seconds).append(", ").append(cxt);
        }

        @Override
        public void leaveLine(long time, long busId, long lowlineId, LineUpDown upDown, ILineEventContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("leaveLine: ").append(time).append(", ").append(busId).append(", ").append(lowlineId).append(", ").append((Object)upDown).append(", ").append(cxt);
        }

        @Override
        public void backLine(long time, long busId, long lowlineId, LineUpDown upDown, int seconds, ILineEventContext cxt) {
            StringBuilder builder = new StringBuilder();
            builder.append("backLine: ").append(time).append(", ").append(busId).append(", ").append(lowlineId).append(", ").append((Object)upDown).append(", ").append(seconds).append(", ").append(cxt);
        }

        @Override
        public void reachArea(long busId, IGps gps, long changId, IAreaReachEventContext areaEventContxt) {
        }

        @Override
        public void leaveArea(long busId, IGps gps, long changId, IAreaReachEventContext areaEventContxt) {
        }
    }

    static class MyLineEventContext
    implements IReachBusstopContext,
    ILeaveLineContext {
        private static final long serialVersionUID = 1L;
        Lowline lowline;
        LineSide lineSide;
        LineBusstop nextBusstop;
        long driverId = 0L;
        IConnContext gpsCxt;

        private MyLineEventContext(Lowline lowline, LineSide lineSide, LineBusstop nextBusstop, long driverId, IConnContext gpsCxt) {
            this.lowline = lowline;
            this.lineSide = lineSide;
            this.nextBusstop = nextBusstop;
            this.driverId = driverId;
            this.gpsCxt = gpsCxt;
        }

        @Override
        public LineBusstop getBusstop() {
            return this.nextBusstop;
        }

        @Override
        public Lowline getLowline() {
            return this.lowline;
        }

        @Override
        public LineUpDown upDown() {
            return this.lineSide.upDown();
        }

        @Override
        public LineSide getLineSide() {
            return this.lineSide;
        }

        @Override
        public long getBusId() {
            return this.gpsCxt.getBusId();
        }

        @Override
        public long getDriverId() {
            return this.driverId;
        }

        @Override
        public InetSocketAddress getClientAddr() {
            return this.gpsCxt.getClientAddr();
        }

        @Override
        public long getTime() {
            return this.gpsCxt.getTime();
        }

        @Override
        public IGps getGps() {
            return this.gpsCxt.getGps();
        }

        public String toString() {
            String builder = "backLine: " + this.lowline.id() + ", " + (Object)((Object)this.lineSide.upDown()) + ", " + this.nextBusstop + ", " + this.gpsCxt;
            return builder;
        }

        @Override
        public Object getProperty(Object key) {
            return this.gpsCxt.getProperty(key);
        }

        @Override
        public void setProperty(Object key, Object val) {
            this.gpsCxt.setProperty(key, val);
        }
    }
}

