/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.line;

import cn.gongler.util.sgeo.geo.GeoUtil;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.IGpsDis;
import java.sql.Time;

class GpsIntervalDis
implements IGpsDis {
    private static final long serialVersionUID = 7470603854726833473L;
    private IGps lastValidGps = null;
    private double curGpsDis = 0.0;
    IGps fromGps;
    IGps toGps;

    public GpsIntervalDis(IGps gps) {
        this.lastValidGps = gps;
        this.curGpsDis = 0.0;
    }

    public GpsIntervalDis() {
        this(null);
    }

    @Override
    public void reset(IGps gps) {
        this.lastValidGps = gps;
        this.curGpsDis = 0.0;
    }

    @Override
    public void pushGps(IGps gps) {
        double moveSpeed;
        if (gps == null) {
            return;
        }
        if (this.lastValidGps == null) {
            this.lastValidGps = gps;
            this.curGpsDis = 0.0;
            return;
        }
        double gpsDis = GeoUtil.GetDistance(this.lastValidGps, gps);
        long timeDis = gps.gpsTime() - this.lastValidGps.gpsTime();
        double hours = (double)timeDis / 1000.0 / 60.0 / 60.0;
        double d = moveSpeed = hours <= 0.0 ? Double.MAX_VALUE : gpsDis / hours;
        if (timeDis > 2400000L) {
            this.lastValidGps = gps;
            this.curGpsDis = 0.0;
            return;
        }
        if (moveSpeed > 200.0) {
            this.lastValidGps = gps;
            this.curGpsDis = 0.0;
            return;
        }
        if (gpsDis > 30.0) {
            this.lastValidGps = gps;
            this.curGpsDis = 0.0;
            return;
        }
        if (this.lastValidGps.gpsSpeed() == 0 && gps.gpsSpeed() == 0 && timeDis < 60000L) {
            this.curGpsDis = 0.0;
            return;
        }
        this.curGpsDis = gpsDis;
        this.fromGps = this.lastValidGps;
        this.toGps = gps;
        this.lastValidGps = gps;
    }

    @Override
    public double getDistance() {
        return this.curGpsDis;
    }

    public String toString() {
        String bd = "GpsDis=" + this.curGpsDis + ", " + new Time(this.fromTime()) + "~" + new Time(this.toTime());
        return bd;
    }

    @Override
    public long fromTime() {
        if (this.fromGps == null) {
            return 0L;
        }
        return this.fromGps.gpsTime();
    }

    @Override
    public long toTime() {
        if (this.toGps == null) {
            return 0L;
        }
        return this.toGps.gpsTime();
    }
}

