/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroup;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.AreaOverspeedEvent;
import cn.gongler.util.sgeo.gps.BusFactory;
import cn.gongler.util.sgeo.gps.BusState;
import cn.gongler.util.sgeo.gps.IGps;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

public class AreaOverspeedChecker {
    private static final long serialVersionUID = 8801167335446322705L;
    private static AreaOverspeedChecker instance;

    public static synchronized AreaOverspeedChecker getInstance() {
        if (instance == null) {
            instance = new AreaOverspeedChecker();
        }
        return instance;
    }

    private AreaOverspeedChecker() {
    }

    private ScopeGroup overspeedGroup() {
        return ScopeGroupFactory.of().group(4L);
    }

    public void check(long busId, IGps gps, Connection conn) throws SQLException {
        BusState bus = BusFactory.getInstance().getBus(busId);
        OverspeedState areaState = (OverspeedState)bus.map.computeIfAbsent("OverspeedState", k -> new OverspeedState());
        long fromTime = areaState.fromTime;
        Scope prevScope = areaState.prevOverspeedScope;
        Scope scope = this.overspeedGroup().firstInside(gps, s -> (long)gps.gpsSpeed() > s.num2() || (long)gps.gpsSpeed() < s.num1());
        if (prevScope == null && scope != null) {
            AreaOverspeedEvent event = AreaOverspeedEvent.Builder.of().isStart(true).scopeId(scope.id()).build();
            AreaOverspeedChecker.dbProc(busId, gps, scope, event, conn);
            areaState.fromTime = gps.gpsTime();
            areaState.speedMax = 0;
        } else if (prevScope != null && scope == null) {
            long seconds = (gps.gpsTime() - fromTime) / 1000L;
            AreaOverspeedEvent event = AreaOverspeedEvent.Builder.of().isStart(false).scopeId(prevScope.id()).maxSpeed(areaState.speedMax).seconds(seconds).build();
            AreaOverspeedChecker.dbProc(busId, gps, prevScope, event, conn);
        }
        areaState.prevOverspeedScope = scope;
        areaState.updateMaxSpeed(gps.gpsSpeed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dbProc(long busId, IGps gps, Scope scopeInfo, AreaOverspeedEvent event, Connection conn) throws SQLException {
        int speedLimitedMax = (int)scopeInfo.num2();
        CallableStatement statement = null;
        try {
            String sql = "CALL PK_SCOPE.EVENT_OVERSPEED (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            statement = conn.prepareCall(sql);
            int pos = 1;
            statement.setTimestamp(pos++, new Timestamp(gps.gpsTime()));
            statement.setLong(pos++, busId);
            statement.setDouble(pos++, gps.gpsLng());
            statement.setDouble(pos++, gps.gpsLat());
            statement.setInt(pos++, gps.gpsSpeed());
            statement.setInt(pos++, gps.gpsAngle());
            statement.setLong(pos++, event.areaId);
            statement.setInt(pos++, speedLimitedMax);
            statement.setInt(pos++, event.isStart ? 0 : 1);
            statement.setLong(pos++, TimeUnit.MILLISECONDS.toSeconds(event.howlong));
            statement.setInt(pos++, event.maxSpeed);
            statement.execute();
        }
        catch (Throwable throwable) {
            GonglerUtil.Close(statement);
            throw throwable;
        }
        GonglerUtil.Close(statement);
    }

    private static class OverspeedState {
        long fromTime = 0L;
        Scope prevOverspeedScope = null;
        private int speedMax;

        private OverspeedState() {
        }

        private void updateMaxSpeed(int gpsSpeed) {
            if (gpsSpeed > this.speedMax) {
                this.speedMax = gpsSpeed;
            }
        }
    }
}

