/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.geo;

import cn.gongler.util.db.ConnectionFactory;
import cn.gongler.util.db.DbUtil;
import cn.gongler.util.sgeo.geo.IGeoPoint;
import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroup;
import cn.gongler.util.tuple.Tuple;
import cn.gongler.util.tuple.Tuple5;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class ScopeGroupFactory {
    private static final long serialVersionUID = 1L;
    private static final ScopeGroupFactory INSTANCE = new ScopeGroupFactory();
    private final Map<Long, ScopeGroup> GROUP_MAP = new ConcurrentSkipListMap<Long, ScopeGroup>();
    public static final LocalDateTime DEFAULT_LOCALDATETIME = LocalDateTime.of(2000, 1, 1, 1, 1);
    public LocalDateTime allLoadTime = DEFAULT_LOCALDATETIME;
    public LocalDateTime allLoadFinishedTime = DEFAULT_LOCALDATETIME;
    public LocalDateTime allLoadSucessTime = DEFAULT_LOCALDATETIME;
    ConnectionFactory connFactory;
    private final Object scopeFirstLoadLock = new Object();
    Thread dbLoadThread = new Thread(() -> {
        try {
            Object object = this.scopeFirstLoadLock;
            synchronized (object) {
                this.scopeFirstLoadLock.wait(TimeUnit.MINUTES.toMillis(30L));
            }
            while (true) {
                try (Connection conn = this.connFactory.getConnection();){
                    this.loadAllFromDb(conn, true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                Thread.sleep(TimeUnit.MINUTES.toMillis(30L));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    });

    public static ScopeGroupFactory of() {
        return INSTANCE;
    }

    private ScopeGroupFactory() {
        this.dbLoadThread.setDaemon(true);
        this.dbLoadThread.start();
        this.register(ScopeGroup.CHANGZHANS_SCOPEGROUP);
        this.register(ScopeGroup.BUSSTOPS_SCOPEGROUP);
        this.register(ScopeGroup.LINESCOPE_SCOPEGROUP);
        this.register(ScopeGroup.OVERSPEED_SCOPEGROUP);
        this.register(ScopeGroup.CITYSCOPE_SCOPEGROUP);
    }

    private void register(ScopeGroup group) {
        this.GROUP_MAP.put(group.id(), group);
    }

    public Map<Long, ScopeGroup> groupMap() {
        return Collections.unmodifiableMap(this.GROUP_MAP);
    }

    public ScopeGroup group(long groupId) {
        return this.GROUP_MAP.computeIfAbsent(groupId, id -> new ScopeGroup((long)id, String.valueOf(id), null));
    }

    public Scope scope(long scopeId) {
        return ScopeGroup.QuickScope(scopeId);
    }

    public Map<Long, Scope> scopeQuickMap() {
        return Collections.unmodifiableMap(ScopeGroup.SCOPE_QUICK_MAP);
    }

    private static Scope LoadScope(Connection conn, Long scopeId) throws SQLException {
        Scope[] ret = new Scope[1];
        DbUtil.ExecuteQuery(conn, "SELECT * FROM GPS_SCOPE_HEADER WHERE SCOPE_DISABLE=0 AND SCOPE_NO=?", (rs, rowIndex) -> {
            Scope scope;
            Scope.Builder scopeBuilder = new Scope.Builder(rs.getLong("SCOPE_NO")).name(rs.getString("SCOPE_NAME")).num1(rs.getLong("EXT_NUM1")).num2(rs.getLong("EXT_NUM2")).group(rs.getLong("SCOPE_GROUP"));
            DbUtil.ExecuteQuery(conn, "SELECT GEO_L, GEO_B FROM GPS_SCOPE_DETAIL WHERE SCOPE_NO=? ORDER BY SERIAL ", (rs2, rowIndex2) -> {
                double geoL = rs2.getDouble("GEO_L");
                double geoB = rs2.getDouble("GEO_B");
                scopeBuilder.add(geoL, geoB);
            }, scopeId);
            ret[0] = scope = scopeBuilder.build();
        }, scopeId);
        return ret[0];
    }

    private static List<Scope> LoadGroup(Connection conn, Long groupId) throws SQLException {
        LinkedList<Scope> list = new LinkedList<Scope>();
        DbUtil.ExecuteQuery(conn, "SELECT SCOPE_NO FROM GPS_SCOPE_HEADER WHERE SCOPE_DISABLE=0 and scope_group =? ORDER BY SCOPE_NO", (rs, rowIndex) -> {
            long scopeId = rs.getLong("SCOPE_NO");
            Scope scope = ScopeGroupFactory.LoadScope(conn, scopeId);
            list.add(scope);
        }, groupId);
        return list;
    }

    private void loadGroup(Connection conn, Long groupId) throws SQLException {
        List<Scope> list = ScopeGroupFactory.LoadGroup(conn, groupId);
        this.group(groupId).addAllScope(list);
        for (Scope scope : this.group(groupId).scopes()) {
        }
    }

    private void loadAll(Connection conn) throws SQLException {
        DbUtil.ExecuteQuery(conn, "SELECT SCOPE_GROUP FROM GPS_SCOPE_HEADER WHERE SCOPE_DISABLE=0 group by SCOPE_GROUP ORDER BY SCOPE_GROUP", (rs, rowIndex) -> this.loadGroup(conn, rs.getLong("SCOPE_GROUP")));
    }

    private void loadAllFast(Connection conn) throws SQLException {
        ArrayList detailList = new ArrayList();
        DbUtil.ExecuteQuery(conn, "SELECT * FROM GPS_SCOPE_DETAIL ORDER BY SCOPE_NO, SERIAL ", (rs2, rowIndex2) -> {
            long scopeId = rs2.getLong("SCOPE_NO");
            double geoL = rs2.getDouble("GEO_L");
            double geoB = rs2.getDouble("GEO_B");
            detailList.add(Tuple.of(scopeId, geoL, geoB));
        });
        ArrayList headerList = new ArrayList();
        DbUtil.ExecuteQuery(conn, "SELECT * FROM GPS_SCOPE_HEADER WHERE SCOPE_DISABLE=0 ORDER BY SCOPE_GROUP,SCOPE_NO ", (rs, rowIndex) -> headerList.add(Tuple.of(rs.getLong("SCOPE_GROUP"), rs.getLong("SCOPE_NO"), rs.getString("SCOPE_NAME"), rs.getLong("EXT_NUM1"), rs.getLong("EXT_NUM2"))));
        headerList.stream().collect(Collectors.groupingBy(Tuple5::first)).forEach((groupId, scopeInfoList) -> {
            ArrayList<Scope> scopesInGroup = new ArrayList<Scope>();
            scopeInfoList.stream().forEach(record -> {
                long scopeId = (Long)record.second();
                Scope.Builder scopeBuilder = new Scope.Builder(scopeId).group((long)groupId).name((String)record.third()).num1((Long)record.forth()).num2((Long)record.fifth());
                detailList.stream().filter(t -> (Long)t.first() == scopeId).forEach(t -> scopeBuilder.add((Double)t.second(), (Double)t.third()));
                Scope scope = scopeBuilder.build();
                scopesInGroup.add(scope);
            });
            this.group((long)groupId).addAllScope(scopesInGroup);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllFromDb(Connection conn, boolean fastMode) throws SQLException {
        this.allLoadTime = LocalDateTime.now();
        try {
            if (fastMode) {
                this.loadAllFast(conn);
            } else {
                this.loadAll(conn);
            }
            this.allLoadSucessTime = LocalDateTime.now();
        }
        finally {
            this.allLoadFinishedTime = LocalDateTime.now();
            int n = this.GROUP_MAP.values().stream().mapToInt(a -> a.scopes().size()).sum();
        }
    }

    public void removeScope(long scopeId) {
        this.GROUP_MAP.values().forEach(group -> group.removeScope(scopeId));
    }

    public void reloadScope(Connection conn, long scopeId) throws SQLException {
        Scope scope = ScopeGroupFactory.LoadScope(conn, scopeId);
        if (scope != null) {
            this.removeScope(scopeId);
            this.group(scope.groupId()).addScope(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScopeGroupFactory connectionFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
        Object object = this.scopeFirstLoadLock;
        synchronized (object) {
            this.scopeFirstLoadLock.notify();
        }
        return this;
    }

    public ScopeGroupFactory connectionFactory(DataSource ds) {
        return this.connectionFactory(ds::getConnection);
    }

    public boolean inside(IGeoPoint gps, long scopeId) {
        Scope scope = this.scope(scopeId);
        if (scope != null) {
            return scope.inside(gps);
        }
        return false;
    }

    public String toString() {
        return "{ScopeGroupFactory,groups:" + this.groupMap().size() + ",allLoadTime:" + this.allLoadTime + "}";
    }
}

